/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.gui.hud.GuiHudAdjust;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.server.MusicOptionsMessage;
import net.aeronica.mods.mxtune.options.ClassifiedPlayer;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiMusicOptions
extends GuiScreen {
    private GuiScreen guiScreenOld;
    private static final String TITLE = I18n.func_135052_a((String)"mxtune.gui.musicOptions.title", (Object[])new Object[0]);
    private static final String LABEL_WHITELIST = I18n.func_135052_a((String)"mxtune.gui.musicOptions.label.whitelist", (Object[])new Object[0]);
    private static final String LABEL_PLAYERS = I18n.func_135052_a((String)"mxtune.gui.musicOptions.label.players", (Object[])new Object[0]);
    private static final String LABEL_BLACKLIST = I18n.func_135052_a((String)"mxtune.gui.musicOptions.label.blacklist", (Object[])new Object[0]);
    private static final String MIDI_NOT_AVAILABLE = I18n.func_135052_a((String)"mxtune.chat.msu.midiNotAvailable", (Object[])new Object[0]);
    private static final String BUTTON_ADJ_HUD = I18n.func_135052_a((String)"mxtune.gui.musicOptions.adjHud", (Object[])new Object[0]);
    private GuiButtonExt buttonMuteOption;
    private GuiButtonExt buttonCancel;
    private GuiPlayerList listBoxPlayers;
    private GuiPlayerList listBoxWhite;
    private GuiPlayerList listBoxBlack;
    private EntityPlayer player;
    private int muteOption;
    private boolean midiUnavailable;
    private int guiListWidth;
    private int entryHeight;
    private List<ClassifiedPlayer> networkPlayers;
    private List<ClassifiedPlayer> whiteListedPlayers;
    private List<ClassifiedPlayer> blackListedPlayers;
    private boolean isStateCached = false;
    private int cachedSelectedPlayerIndex = -1;
    private int cachedSelectedWhiteIndex = -1;
    private int cachedSelectedBlackIndex = -1;
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private static final Ordering<ClassifiedPlayer> LIST_ORDERING = Ordering.from((Comparator)new PlayerListsComparator());

    public GuiMusicOptions(@Nullable GuiScreen guiScreenIn) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.player = this.field_146297_k.field_71439_g;
        this.guiScreenOld = guiScreenIn;
        this.muteOption = MusicOptionsUtil.getMuteOption(this.player);
        this.midiUnavailable = MIDISystemUtil.midiUnavailable();
        this.initPlayerLists();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.guiListWidth = this.field_146297_k.field_71466_p.func_78256_a("MWMWMWMWMWMWMWMW") + 10 + 12;
        this.entryHeight = this.field_146297_k.field_71466_p.field_78288_b + 2;
        int y = (this.field_146295_m - 100) / 3;
        int left = (this.field_146294_l - (this.guiListWidth * 3 + 24 + 24)) / 2;
        int listHeight = this.field_146295_m - 32 - 100 + 4;
        int listTop = 32;
        int listBottom = this.field_146295_m - 100 + 4;
        this.listBoxWhite = new GuiPlayerList(this, this.whiteListedPlayers, this.guiListWidth, listHeight, listTop, listBottom, left);
        GuiButtonExt buttonWhiteToPlayers = new GuiButtonExt(11, this.listBoxWhite.getRight() + 2, y, 20, 20, ">");
        GuiButtonExt buttonPlayersToWhite = new GuiButtonExt(12, this.listBoxWhite.getRight() + 2, y + 25, 20, 20, "<");
        this.listBoxPlayers = new GuiPlayerList(this, this.networkPlayers, this.guiListWidth, listHeight, listTop, listBottom, this.listBoxWhite.getRight() + 24);
        GuiButtonExt buttonPlayersToBlack = new GuiButtonExt(13, this.listBoxPlayers.getRight() + 2, y, 20, 20, ">");
        GuiButtonExt buttonBlackToPlayers = new GuiButtonExt(14, this.listBoxPlayers.getRight() + 2, y + 25, 20, 20, "<");
        this.listBoxBlack = new GuiPlayerList(this, this.blackListedPlayers, this.guiListWidth, listHeight, listTop, listBottom, this.listBoxPlayers.getRight() + 24);
        int buttonWidth = 100;
        y = this.field_146295_m - 100 + 4 + 5;
        left = this.listBoxBlack.getRight() - buttonWidth + 2;
        GuiButtonExt buttonDone = new GuiButtonExt(3, left, y, buttonWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonCancel = new GuiButtonExt(2, left, y + 22, buttonWidth, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        y = this.field_146295_m - 100 + 4 + 5;
        left = this.listBoxWhite.getRight() - this.guiListWidth - 2;
        buttonWidth = 225;
        this.buttonMuteOption = new GuiButtonExt(0, left, y, buttonWidth, 20, MusicOptionsUtil.EnumMuteOptions.byIndex(this.muteOption).toString());
        GuiButtonExt buttonAdjHud = new GuiButtonExt(4, left, y += 22, buttonWidth, 20, BUTTON_ADJ_HUD);
        this.field_146292_n.add(buttonWhiteToPlayers);
        this.field_146292_n.add(buttonPlayersToWhite);
        this.field_146292_n.add(buttonPlayersToBlack);
        this.field_146292_n.add(buttonBlackToPlayers);
        this.field_146292_n.add(this.buttonMuteOption);
        this.field_146292_n.add(this.buttonCancel);
        this.field_146292_n.add(buttonDone);
        this.field_146292_n.add(buttonAdjHud);
        this.reloadState();
    }

    private void reloadState() {
        if (!this.isStateCached) {
            return;
        }
        this.listBoxPlayers.elementClicked(this.cachedSelectedPlayerIndex, false);
        this.listBoxWhite.elementClicked(this.cachedSelectedWhiteIndex, false);
        this.listBoxBlack.elementClicked(this.cachedSelectedBlackIndex, false);
    }

    private void updateState() {
        this.cachedSelectedPlayerIndex = this.listBoxPlayers.getSelectedIndex();
        this.cachedSelectedWhiteIndex = this.listBoxWhite.getSelectedIndex();
        this.cachedSelectedBlackIndex = this.listBoxBlack.getSelectedIndex();
        this.isStateCached = true;
    }

    public void func_146281_b() {
        ModConfig.RegistrationHandler.sync();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        String localTITLE = this.midiUnavailable ? TITLE + " - " + TextFormatting.RED + MIDI_NOT_AVAILABLE : TITLE;
        int posX = (this.field_146294_l - this.field_146297_k.field_71466_p.func_78256_a(localTITLE)) / 2;
        int posY = 10;
        this.field_146297_k.field_71466_p.func_175063_a(localTITLE, (float)posX, (float)posY, 0xD3D3D3);
        posX = this.listBoxWhite.getRight() - this.guiListWidth / 2 - this.field_146297_k.field_71466_p.func_78256_a(LABEL_WHITELIST) / 2;
        posY = 20;
        this.field_146297_k.field_71466_p.func_175063_a(LABEL_WHITELIST, (float)posX, (float)posY, 0xD3D3D3);
        posX = this.listBoxPlayers.getRight() - this.guiListWidth / 2 - this.field_146297_k.field_71466_p.func_78256_a(LABEL_PLAYERS) / 2;
        posY = 20;
        this.field_146297_k.field_71466_p.func_175063_a(LABEL_PLAYERS, (float)posX, (float)posY, 0xD3D3D3);
        posX = this.listBoxBlack.getRight() - this.guiListWidth / 2 - this.field_146297_k.field_71466_p.func_78256_a(LABEL_BLACKLIST) / 2;
        posY = 20;
        this.field_146297_k.field_71466_p.func_175063_a(LABEL_BLACKLIST, (float)posX, (float)posY, 0xD3D3D3);
        this.listBoxWhite.drawScreen(mouseX, mouseY, partialTicks);
        this.listBoxPlayers.drawScreen(mouseX, mouseY, partialTicks);
        this.listBoxBlack.drawScreen(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
    }

    protected void func_146284_a(GuiButton guibutton) {
        switch (guibutton.field_146127_k) {
            case 0: {
                ++this.muteOption;
                this.muteOption %= MusicOptionsUtil.EnumMuteOptions.values().length;
                this.buttonMuteOption.field_146126_j = MusicOptionsUtil.EnumMuteOptions.byIndex(this.muteOption).toString();
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.sendOptionsToServer(this.muteOption);
                ModConfig.RegistrationHandler.sync();
                this.field_146297_k.func_147108_a(this.guiScreenOld);
                break;
            }
            case 2: {
                ModConfig.RegistrationHandler.sync();
                this.field_146297_k.func_147108_a(this.guiScreenOld);
                break;
            }
            case 4: {
                this.sendOptionsToServer(this.muteOption);
                this.field_146297_k.func_147108_a((GuiScreen)new GuiHudAdjust(this));
                break;
            }
            case 11: {
                this.moveSelectedPlayer(this.listBoxWhite, this.whiteListedPlayers, this.networkPlayers);
                break;
            }
            case 12: {
                this.moveSelectedPlayer(this.listBoxPlayers, this.networkPlayers, this.whiteListedPlayers);
                break;
            }
            case 13: {
                this.moveSelectedPlayer(this.listBoxPlayers, this.networkPlayers, this.blackListedPlayers);
                break;
            }
            case 14: {
                this.moveSelectedPlayer(this.listBoxBlack, this.blackListedPlayers, this.networkPlayers);
                break;
            }
        }
        this.sortLists();
        this.updateState();
    }

    private void moveSelectedPlayer(GuiPlayerList listBoxFrom, List<ClassifiedPlayer> playersFrom, List<ClassifiedPlayer> playersTo) {
        int selectedIndex = listBoxFrom.getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex > playersFrom.size() || playersFrom.isEmpty()) {
            return;
        }
        ClassifiedPlayer classifiedPlayerRef = playersFrom.get(selectedIndex);
        playersFrom.remove(selectedIndex);
        playersTo.add(classifiedPlayerRef);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a((GuiButton)this.buttonCancel);
            return;
        }
        this.updateState();
        super.func_73869_a(typedChar, keyCode);
    }

    private void sendOptionsToServer(int muteOption) {
        PacketDispatcher.sendToServer(new MusicOptionsMessage(muteOption, this.blackListedPlayers, this.whiteListedPlayers));
    }

    private void initPlayerLists() {
        this.networkPlayers = new ArrayList<ClassifiedPlayer>();
        this.whiteListedPlayers = MusicOptionsUtil.getWhiteList(this.player);
        this.blackListedPlayers = MusicOptionsUtil.getBlackList(this.player);
        if (!this.field_146297_k.func_71387_A() || this.field_146297_k.field_71439_g.field_71174_a.func_175106_d().size() > 1) {
            NetHandlerPlayClient nethandlerplayclient = this.field_146297_k.field_71439_g.field_71174_a;
            List list = ENTRY_ORDERING.sortedCopy((Iterable)nethandlerplayclient.func_175106_d());
            for (NetworkPlayerInfo networkplayerinfo : list) {
                ClassifiedPlayer networkPlayer = new ClassifiedPlayer();
                networkPlayer.setPlayerName(this.getPlayerName(networkplayerinfo));
                networkPlayer.setOnline(true);
                networkPlayer.setUuid(networkplayerinfo.func_178845_a().getId());
                if (networkPlayer.getUuid().equals(this.player.func_110124_au())) continue;
                this.networkPlayers.add(networkPlayer);
            }
        }
        this.initClassifiedPlayerList(this.networkPlayers, this.blackListedPlayers);
        this.initClassifiedPlayerList(this.networkPlayers, this.whiteListedPlayers);
        this.sortLists();
    }

    private void initClassifiedPlayerList(List<ClassifiedPlayer> netPlayers, List<ClassifiedPlayer> classifiedPlayers) {
        for (ClassifiedPlayer classifiedPlayer : classifiedPlayers) {
            for (int i = 0; i < netPlayers.size(); ++i) {
                ClassifiedPlayer nPlayer = netPlayers.get(i);
                if (!nPlayer.getUuid().equals(classifiedPlayer.getUuid())) continue;
                classifiedPlayer.setOnline(true);
                classifiedPlayer.setPlayerName(nPlayer.getPlayerName());
                netPlayers.remove(i);
            }
        }
    }

    private void sortLists() {
        List tempWhiteList = LIST_ORDERING.sortedCopy(this.whiteListedPlayers);
        this.whiteListedPlayers.clear();
        this.whiteListedPlayers.addAll(tempWhiteList);
        List tempBlackList = LIST_ORDERING.sortedCopy(this.blackListedPlayers);
        this.blackListedPlayers.clear();
        this.blackListedPlayers.addAll(tempBlackList);
        List tempPlayerList = LIST_ORDERING.sortedCopy(this.networkPlayers);
        this.networkPlayers.clear();
        this.networkPlayers.addAll(tempPlayerList);
    }

    private String getPlayerName(NetworkPlayerInfo networkPlayerInfoIn) {
        return networkPlayerInfoIn.func_178854_k() != null ? networkPlayerInfoIn.func_178854_k().func_150254_d() : ScorePlayerTeam.func_96667_a((Team)networkPlayerInfoIn.func_178850_i(), (String)networkPlayerInfoIn.func_178845_a().getName());
    }

    static /* synthetic */ float access$100(GuiMusicOptions x0) {
        return x0.field_73735_i;
    }

    static /* synthetic */ float access$400(GuiMusicOptions x0) {
        return x0.field_73735_i;
    }

    static class PlayerListsComparator
    implements Comparator<ClassifiedPlayer> {
        private PlayerListsComparator() {
        }

        @Override
        public int compare(ClassifiedPlayer o1, ClassifiedPlayer o2) {
            return ComparisonChain.start().compareTrueFirst(o1.isOnline(), o2.isOnline()).compare((Comparable)((Object)o1.getPlayerName()), (Comparable)((Object)o2.getPlayerName())).result();
        }
    }

    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo pCompare1, NetworkPlayerInfo pCompare2) {
            return ComparisonChain.start().compare((Comparable)((Object)pCompare1.func_178845_a().getName()), (Comparable)((Object)pCompare2.func_178845_a().getName())).result();
        }
    }

    public static class GuiPlayerList
    extends GuiScrollingList {
        private List<ClassifiedPlayer> classifiedPlayers;
        private FontRenderer fontRenderer;
        private GuiMusicOptions parent;

        GuiPlayerList(GuiMusicOptions parent, List<ClassifiedPlayer> playerListIn, int width, int height, int top, int bottom, int left) {
            super(parent.field_146297_k, width, height, top, bottom, left, parent.entryHeight, parent.field_146294_l, parent.field_146295_m);
            this.fontRenderer = parent.field_146297_k.field_71466_p;
            this.parent = parent;
            this.classifiedPlayers = playerListIn;
        }

        int getRight() {
            return this.right;
        }

        int getSelectedIndex() {
            return this.selectedIndex;
        }

        protected int getSize() {
            return this.classifiedPlayers.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (index == this.selectedIndex) {
                return;
            }
            this.selectedIndex = index >= 0 && index <= this.classifiedPlayers.size() ? index : -1;
        }

        protected boolean isSelected(int index) {
            return index == this.selectedIndex && this.selectedIndex >= 0 && this.selectedIndex <= this.classifiedPlayers.size();
        }

        protected void drawBackground() {
            Gui.func_73734_a((int)(this.left - 1), (int)(this.top - 1), (int)(this.left + this.listWidth + 1), (int)(this.top + this.listHeight + 1), (int)-6250336);
            Gui.func_73734_a((int)this.left, (int)this.top, (int)(this.left + this.listWidth), (int)(this.top + this.listHeight), (int)-16777216);
        }

        protected int getContentHeight() {
            return this.getSize() * this.slotHeight;
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            String name = this.classifiedPlayers.get(slotIdx).getPlayerName();
            String trimmedName = this.fontRenderer.func_78269_a(name, this.listWidth - 10);
            this.fontRenderer.func_175063_a(trimmedName, (float)this.left + 3.0f, (float)slotTop, 11393254);
            GuiPlayerList.drawPing(this.parent, this.left + 3, this.listWidth - 10, slotTop, this.classifiedPlayers.get(slotIdx));
        }

        private static void drawPing(GuiMusicOptions parent, int x, int sWidth, int y, ClassifiedPlayer playerInfo) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            parent.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
            int offset = playerInfo.isOnline() ? 0 : 5;
            GuiMusicOptions guiMusicOptions = parent;
            guiMusicOptions.field_73735_i = guiMusicOptions.field_73735_i + 100.0f;
            parent.func_73729_b(sWidth + x - 11, y, 0, 176 + offset * 8, 10, 8);
            guiMusicOptions = parent;
            guiMusicOptions.field_73735_i = guiMusicOptions.field_73735_i - 100.0f;
        }
    }
}

