/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui;

import net.aeronica.mods.mxtune.blocks.TileBandAmp;
import net.aeronica.mods.mxtune.gui.util.GuiButtonMX;
import net.aeronica.mods.mxtune.gui.util.GuiLockButton;
import net.aeronica.mods.mxtune.gui.util.GuiRedstoneButton;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.server.BandAmpMessage;
import net.aeronica.mods.mxtune.sound.SoundRange;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.world.LockableHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBandAmp
extends GuiContainer {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("mxtune", "textures/gui/band_amp.png");
    private InventoryPlayer inventoryPlayer;
    private TileBandAmp tileBandAmp;
    private GuiLockButton lockButton;
    private GuiRedstoneButton rearInputButton;
    private GuiRedstoneButton leftOutputButton;
    private GuiRedstoneButton rightOutputButton;
    private GuiButtonMX soundRangeButton;
    private boolean prevLockState;
    private boolean prevRearInputButtonState;
    private boolean prevLeftOutputButtonState;
    private boolean prevRightOutputButtonState;
    private SoundRange soundRange;
    private SoundRange prevSoundRange;

    public GuiBandAmp(Container container, InventoryPlayer inventoryPlayer, TileBandAmp tileBandAmp) {
        super(container);
        this.inventoryPlayer = inventoryPlayer;
        this.tileBandAmp = tileBandAmp;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        boolean isEnabled = LockableHelper.canLock((EntityPlayer)this.field_146297_k.field_71439_g, this.tileBandAmp);
        this.prevSoundRange = this.soundRange = this.tileBandAmp.getSoundRange();
        this.lockButton = new GuiLockButton(100, this.field_147003_i + 16, this.field_147009_r + 25);
        this.lockButton.addHooverTexts(I18n.func_135052_a((String)"mxtune.gui.bandAmp.lockButton.help01", (Object[])new Object[0]));
        this.lockButton.addHooverTexts(TextFormatting.GREEN + I18n.func_135052_a((String)"mxtune.gui.bandAmp.lockButton.help02", (Object[])new Object[0]));
        this.lockButton.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.bandAmp.lockButton.help03", (Object[])new Object[0]));
        this.field_146292_n.add(this.lockButton);
        this.lockButton.setLocked(this.tileBandAmp.isLocked());
        this.lockButton.field_146124_l = isEnabled;
        this.prevLockState = this.lockButton.isLocked();
        this.rearInputButton = new GuiRedstoneButton(101, this.field_147003_i + 139, this.field_147009_r + 25, GuiRedstoneButton.ArrowFaces.DOWN);
        this.rearInputButton.addHooverTexts(I18n.func_135052_a((String)"mxtune.gui.bandAmp.rearInputButton.help01", (Object[])new Object[0]));
        this.rearInputButton.addHooverTexts(TextFormatting.GREEN + I18n.func_135052_a((String)"mxtune.gui.bandAmp.rearInputButton.help02", (Object[])new Object[0]));
        this.rearInputButton.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.bandAmp.rearInputButton.help03", (Object[])new Object[0]));
        this.field_146292_n.add(this.rearInputButton);
        this.rearInputButton.setSignalEnabled(this.tileBandAmp.isRearRedstoneInputEnabled());
        this.rearInputButton.field_146124_l = isEnabled;
        this.prevRearInputButtonState = this.rearInputButton.isSignalEnabled();
        this.leftOutputButton = new GuiRedstoneButton(102, this.field_147003_i + 129, this.field_147009_r + 45, GuiRedstoneButton.ArrowFaces.LEFT);
        this.leftOutputButton.addHooverTexts(I18n.func_135052_a((String)"mxtune.gui.bandAmp.leftOutputButton.help01", (Object[])new Object[0]));
        this.leftOutputButton.addHooverTexts(TextFormatting.GREEN + I18n.func_135052_a((String)"mxtune.gui.bandAmp.leftOutputButton.help02", (Object[])new Object[0]));
        this.leftOutputButton.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.bandAmp.leftOutputButton.help03", (Object[])new Object[0]));
        this.field_146292_n.add(this.leftOutputButton);
        this.leftOutputButton.setSignalEnabled(this.tileBandAmp.isLeftRedstoneOutputEnabled());
        this.leftOutputButton.field_146124_l = isEnabled;
        this.prevLeftOutputButtonState = this.leftOutputButton.isSignalEnabled();
        this.rightOutputButton = new GuiRedstoneButton(103, this.field_147003_i + 149, this.field_147009_r + 45, GuiRedstoneButton.ArrowFaces.RIGHT);
        this.rightOutputButton.addHooverTexts(I18n.func_135052_a((String)"mxtune.gui.bandAmp.rightOutputButton.help01", (Object[])new Object[0]));
        this.rightOutputButton.addHooverTexts(TextFormatting.GREEN + I18n.func_135052_a((String)"mxtune.gui.bandAmp.rightOutputButton.help02", (Object[])new Object[0]));
        this.rightOutputButton.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.bandAmp.rightOutputButton.help03", (Object[])new Object[0]));
        this.field_146292_n.add(this.rightOutputButton);
        this.rightOutputButton.setSignalEnabled(this.tileBandAmp.isRightRedstoneOutputEnabled());
        this.rightOutputButton.field_146124_l = isEnabled;
        this.prevRightOutputButtonState = this.rightOutputButton.isSignalEnabled();
        this.soundRangeButton = new GuiButtonMX(104, this.field_147003_i + 6, this.field_147009_r + 45, 40, 20, "");
        this.soundRangeButton.field_146126_j = I18n.func_135052_a((String)this.soundRange.getLanguageKey(), (Object[])new Object[0]);
        this.soundRangeButton.addHooverTexts(I18n.func_135052_a((String)"mxtune.gui.bandAmp.soundRangeButton.help01", (Object[])new Object[0]));
        this.soundRangeButton.addHooverTexts(TextFormatting.GREEN + I18n.func_135052_a((String)"mxtune.gui.bandAmp.soundRangeButton.help02", (Object[])new Object[0]));
        this.soundRangeButton.addHooverTexts(TextFormatting.YELLOW + I18n.func_135052_a((String)"mxtune.gui.bandAmp.soundRangeButton.help03", (Object[])new Object[0]));
        this.field_146292_n.add(this.soundRangeButton);
        this.soundRangeButton.field_146124_l = isEnabled;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.sendButtonChanges();
    }

    protected void func_146284_a(GuiButton button) {
        this.toggleLockButton(this.lockButton, button);
        this.toggleRedstoneButton(this.rearInputButton, button);
        this.toggleRedstoneButton(this.leftOutputButton, button);
        this.toggleRedstoneButton(this.rightOutputButton, button);
        this.nextRangeButton((GuiButton)this.soundRangeButton, button);
    }

    private void toggleLockButton(GuiLockButton lockIconButton, GuiButton buttonClicked) {
        if (buttonClicked.field_146127_k == lockIconButton.field_146127_k) {
            boolean invertButton = !lockIconButton.isLocked();
            lockIconButton.setLocked(invertButton);
            this.sendButtonChanges();
        }
    }

    private void toggleRedstoneButton(GuiRedstoneButton guiRedstoneButton, GuiButton buttonClicked) {
        if (buttonClicked.field_146127_k == guiRedstoneButton.field_146127_k) {
            boolean invertButton = !guiRedstoneButton.isSignalEnabled();
            guiRedstoneButton.setSignalEnabled(invertButton);
            this.sendButtonChanges();
        }
    }

    private void nextRangeButton(GuiButton guiRangeButton, GuiButton buttonClicked) {
        if (buttonClicked.field_146127_k == guiRangeButton.field_146127_k) {
            this.soundRange = SoundRange.nextRange(this.soundRange);
            this.sendButtonChanges();
        }
    }

    private void updateButtonStatus() {
        boolean isOwnerManaged = LockableHelper.canLock((EntityPlayer)this.field_146297_k.field_71439_g, this.tileBandAmp);
        String ownerText = isOwnerManaged ? "" : I18n.func_135052_a((String)"mxtune.gui.button.ownerManaged", (Object[])new Object[0]);
        this.updateLockButtonStatus();
        boolean state = this.tileBandAmp.isRearRedstoneInputEnabled();
        this.lockButton.setStatusText(TextFormatting.AQUA + (this.prevLockState ? I18n.func_135052_a((String)"mxtune.gui.bandAmp.lockButton.locked", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.bandAmp.lockButton.unLocked", (Object[])new Object[0]) + ownerText));
        this.prevRearInputButtonState = this.updateButtonStatus(this.rearInputButton, state, this.prevRearInputButtonState);
        this.rearInputButton.setStatusText(TextFormatting.AQUA + (this.rearInputButton.isSignalEnabled() ? I18n.func_135052_a((String)"mxtune.gui.bandAmp.rearInputButton.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.bandAmp.rearInputButton.disabled", (Object[])new Object[0])) + ownerText);
        state = this.tileBandAmp.isLeftRedstoneOutputEnabled();
        this.prevLeftOutputButtonState = this.updateButtonStatus(this.leftOutputButton, state, this.prevLeftOutputButtonState);
        this.leftOutputButton.setStatusText(TextFormatting.AQUA + (this.leftOutputButton.isSignalEnabled() ? I18n.func_135052_a((String)"mxtune.gui.bandAmp.leftOutputButton.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.bandAmp.leftOutputButton.disabled", (Object[])new Object[0])) + ownerText);
        state = this.tileBandAmp.isRightRedstoneOutputEnabled();
        this.prevRightOutputButtonState = this.updateButtonStatus(this.rightOutputButton, state, this.prevRightOutputButtonState);
        this.rightOutputButton.setStatusText(TextFormatting.AQUA + (this.rightOutputButton.isSignalEnabled() ? I18n.func_135052_a((String)"mxtune.gui.bandAmp.rightOutputButton.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"mxtune.gui.bandAmp.rightOutputButton.disabled", (Object[])new Object[0])) + ownerText);
        this.soundRangeButton.setStatusText(TextFormatting.AQUA + this.soundRangeButton.field_146126_j + ownerText);
        this.updateSoundRangeButton();
    }

    private void updateLockButtonStatus() {
        boolean lockState = this.tileBandAmp.isLocked();
        if (this.prevLockState != lockState) {
            this.lockButton.setLocked(lockState);
            this.prevLockState = lockState;
        }
    }

    private void updateSoundRangeButton() {
        this.soundRange = this.tileBandAmp.getSoundRange();
        if (this.prevSoundRange != this.soundRange) {
            this.soundRangeButton.field_146126_j = I18n.func_135052_a((String)this.soundRange.getLanguageKey(), (Object[])new Object[0]);
            this.prevSoundRange = this.soundRange;
        }
    }

    private boolean updateButtonStatus(GuiRedstoneButton button, boolean buttonState, boolean prevState) {
        if (prevState != buttonState) {
            button.setSignalEnabled(buttonState);
        }
        return buttonState;
    }

    private void sendButtonChanges() {
        PacketDispatcher.sendToServer(new BandAmpMessage(this.tileBandAmp.func_174877_v(), this.lockButton.isLocked(), this.rearInputButton.isSignalEnabled(), this.leftOutputButton.isSignalEnabled(), this.rightOutputButton.isSignalEnabled(), this.soundRange));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.updateButtonStatus();
        String name = I18n.func_135052_a((String)this.tileBandAmp.func_70005_c_(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, 8, 6, 0x404040);
        String duration = SheetMusicUtil.formatDuration(this.tileBandAmp.getDuration());
        int durationLength = this.field_146289_q.func_78256_a(duration) + 8;
        this.field_146289_q.func_78276_b(duration, this.field_146999_f - durationLength, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.inventoryPlayer.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94, 0x404040);
        String helpText = I18n.func_135052_a((String)"mxtune.gui.bandAmp.sneakHelp", (Object[])new Object[0]);
        int helpLength = this.field_146289_q.func_78256_a(helpText) + 8;
        this.field_146289_q.func_78276_b(helpText, this.field_146999_f - helpLength, this.field_147000_g - 94, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        ModGuiUtils.INSTANCE.drawHooveringHelp(this, this.field_146292_n, this.field_147003_i, this.field_147009_r, mouseX, mouseY);
    }
}

