/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.entity.living;

import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.init.ModLootTables;
import net.aeronica.mods.mxtune.sound.ModSoundEvents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeHooks;

public class EntityTimpani
extends EntityLiving
implements IMob {
    private static final DataParameter<Integer> TIMPANI_SIZE = EntityDataManager.func_187226_a(EntityTimpani.class, (DataSerializer)DataSerializers.field_187192_b);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public EntityTimpani(World worldIn) {
        super(worldIn);
        this.field_70765_h = new TimpaniMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITimpaniFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AITimpaniAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITimpaniFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AITimpaniHop(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)this, EntitySnowman.class));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TIMPANI_SIZE, (Object)1);
    }

    protected void setTimpaniSize(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(TIMPANI_SIZE, (Object)size);
        this.func_70105_a(0.51000005f * (float)size, 0.51000005f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)size * (double)size);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f + (double)0.1f * (double)size);
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = size;
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)size * 3.0);
    }

    public int getTimpaniSize() {
        return (Integer)this.field_70180_af.func_187225_a(TIMPANI_SIZE);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Size", this.getTimpaniSize() - 1);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setTimpaniSize(i + 1, false);
        this.wasOnGround = compound.func_74767_n("wasOnGround");
    }

    public boolean isSmallSlime() {
        return this.getTimpaniSize() <= 1;
    }

    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.NOTE;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.getTimpaniSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.getTimpaniSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.getParticleType();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    public boolean func_70601_bi() {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && iblockstate.func_189884_a((Entity)this);
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    protected EntityTimpani createInstance() {
        return new EntityTimpani(this.field_70170_p);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isSmallSlime() ? LootTableList.field_186419_a : ModLootTables.ENTITY_TIMPANI_OF_DOOM;
    }

    protected int getJumpDelay() {
        return (this.field_70146_Z.nextInt(20) + 10) * 4;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.5f;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.22f + (float)this.getTimpaniSize() * 0.1f;
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void func_180466_bG() {
        this.field_70181_x = 0.22f + (float)this.getTimpaniSize() * 0.05f;
        this.field_70160_al = true;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (TIMPANI_SIZE.equals(key)) {
            int i = this.getTimpaniSize();
            this.func_70105_a(0.51000005f * (float)i, 0.51000005f * (float)i);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public void func_70106_y() {
        int i = this.getTimpaniSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityTimpani entityTimpani = this.createInstance();
                if (this.func_145818_k_()) {
                    entityTimpani.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    entityTimpani.func_110163_bv();
                }
                entityTimpani.setTimpaniSize(i / 2, true);
                entityTimpani.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityTimpani);
            }
        }
        super.func_70106_y();
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof EntityIronGolem && this.canDamagePlayer()) {
            this.dealDamage((EntityLivingBase)entityIn);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.canDamagePlayer()) {
            this.dealDamage((EntityLivingBase)entityIn);
        }
    }

    protected void dealDamage(EntityLivingBase entityIn) {
        int i = this.getTimpaniSize();
        if (this.func_70685_l((Entity)entityIn) && this.func_70068_e((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((EntityLivingBase)this, (Entity)entityIn);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected boolean canDamagePlayer() {
        return true;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficulty.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.setTimpaniSize(j, true);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected int getAttackStrength() {
        return this.getTimpaniSize() + 2;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getTimpaniSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isSmallSlime() ? ModSoundEvents.ENTITY_TINY_TIMPANI_HURT : ModSoundEvents.ENTITY_TIMPANI_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return this.isSmallSlime() ? ModSoundEvents.ENTITY_TINY_TIMPANI_DEATH : ModSoundEvents.ENTITY_TIMPANI_DEATH;
    }

    protected SoundEvent getSquishSound() {
        int timpaniSize = this.getTimpaniSize();
        SoundEvent soundEvent = ModSoundEvents.ENTITY_MEDIUM_TIMPANI_SQUISH;
        switch (timpaniSize) {
            case 1: {
                soundEvent = ModSoundEvents.ENTITY_TINY_TIMPANI_SQUISH;
                break;
            }
            case 2: {
                soundEvent = ModSoundEvents.ENTITY_MEDIUM_TIMPANI_SQUISH;
                break;
            }
            case 4: {
                soundEvent = ModSoundEvents.ENTITY_LARGE_TIMPANI_SQUISH;
                break;
            }
        }
        return soundEvent;
    }

    protected SoundEvent getJumpSound() {
        return ModSoundEvents.ENTITY_TIMPANI_JUMP;
    }

    protected boolean spawnCustomParticles() {
        if (this.func_130014_f_().field_72995_K) {
            int i = this.getTimpaniSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                double d2 = this.func_174813_aQ().field_72338_b;
                MXTune.proxy.spawnTimpaniParticle(this.func_130014_f_(), d0, d2, d1);
            }
        }
        return true;
    }

    protected boolean makesSoundOnJump() {
        return this.getTimpaniSize() > 0;
    }

    static class TimpaniMoveHelper
    extends EntityMoveHelper {
        private final EntityTimpani timpani;
        private float yRot;
        private int jumpDelay;
        private boolean isAggressive;

        public TimpaniMoveHelper(EntityTimpani timpaniIn) {
            super((EntityLiving)timpaniIn);
            this.timpani = timpaniIn;
            this.yRot = 180.0f * timpaniIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.timpani.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.timpani.func_70683_ar().func_75660_a();
                        if (this.timpani.makesSoundOnJump()) {
                            this.timpani.func_184185_a(this.timpani.getJumpSound(), this.timpani.func_70599_aP(), ((this.timpani.func_70681_au().nextFloat() - this.timpani.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.timpani.field_70702_br = 0.0f;
                        this.timpani.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AITimpaniHop
    extends EntityAIBase {
        private final EntityTimpani timpani;

        public AITimpaniHop(EntityTimpani timpaniIn) {
            this.timpani = timpaniIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((TimpaniMoveHelper)this.timpani.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AITimpaniFloat
    extends EntityAIBase {
        private final EntityTimpani timpani;

        public AITimpaniFloat(EntityTimpani timpaniIn) {
            this.timpani = timpaniIn;
            this.func_75248_a(5);
            ((PathNavigateGround)timpaniIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.timpani.func_70090_H() || this.timpani.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.timpani.func_70681_au().nextFloat() < 0.8f) {
                this.timpani.func_70683_ar().func_75660_a();
            }
            ((TimpaniMoveHelper)this.timpani.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AITimpaniFaceRandom
    extends EntityAIBase {
        private final EntityTimpani timpani;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AITimpaniFaceRandom(EntityTimpani timpaniIn) {
            this.timpani = timpaniIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.timpani.func_70638_az() == null && (this.timpani.field_70122_E || this.timpani.func_70090_H() || this.timpani.func_180799_ab() || this.timpani.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.timpani.func_70681_au().nextInt(60);
                this.chosenDegrees = this.timpani.func_70681_au().nextInt(360);
            }
            ((TimpaniMoveHelper)this.timpani.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AITimpaniAttack
    extends EntityAIBase {
        private final EntityTimpani timpani;
        private int growTieredTimer;

        public AITimpaniAttack(EntityTimpani timpaniIn) {
            this.timpani = timpaniIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.timpani.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.isDaylight() && this.timpani.func_70643_av() == null) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        private boolean isDaylight() {
            long time = this.timpani.func_130014_f_().func_72820_D() % 24000L;
            return time <= 13200L || time >= 23200L;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.timpani.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.timpani.func_70625_a((Entity)this.timpani.func_70638_az(), 10.0f, 10.0f);
            ((TimpaniMoveHelper)this.timpani.func_70605_aq()).setDirection(this.timpani.field_70177_z, this.timpani.canDamagePlayer());
        }
    }
}

