/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.advancements.ModCriteriaTriggers;
import net.aeronica.mods.mxtune.blocks.IPlacedInstrument;
import net.aeronica.mods.mxtune.blocks.TilePiano;
import net.aeronica.mods.mxtune.entity.EntitySittableBlock;
import net.aeronica.mods.mxtune.gui.hud.GuiJamOverlay;
import net.aeronica.mods.mxtune.init.ModItems;
import net.aeronica.mods.mxtune.inventory.IMusic;
import net.aeronica.mods.mxtune.managers.PlayManager;
import net.aeronica.mods.mxtune.status.ServerCSDManager;
import net.aeronica.mods.mxtune.util.PlacedInstrumentUtil;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPiano
extends BlockHorizontal
implements IPlacedInstrument {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    private static final AxisAlignedBB PIANO_BODY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB MUSIC_RACK_AABB_NW = new AxisAlignedBB(0.0, 1.0, 0.0, 0.5, 1.5, 0.5);
    private static final AxisAlignedBB MUSIC_RACK_AABB_SW = new AxisAlignedBB(0.0, 1.0, 0.5, 0.5, 1.5, 1.0);
    private static final AxisAlignedBB MUSIC_RACK_AABB_NE = new AxisAlignedBB(0.5, 1.0, 0.0, 1.0, 1.5, 0.5);
    private static final AxisAlignedBB MUSIC_RACK_AABB_SE = new AxisAlignedBB(0.5, 1.0, 0.5, 1.0, 1.5, 1.0);

    public BlockPiano() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)EnumPartType.LEFT)).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.FALSE));
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.8f);
        this.func_149649_H();
    }

    public boolean func_180639_a(World worldIn, BlockPos posIn, IBlockState stateIn, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos pos = new BlockPos((Vec3i)posIn);
        IBlockState state = stateIn;
        if (state.func_177229_b(PART) == EnumPartType.RIGHT && (state = worldIn.func_180495_p(pos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d()))).func_177230_c() != this) {
            return true;
        }
        if (!worldIn.field_72995_K) {
            boolean playerHasMusic;
            TilePiano tile = (TilePiano)this.getTE(worldIn, pos);
            if (tile.func_145837_r()) {
                return true;
            }
            boolean isOccupied = PlacedInstrumentUtil.isSomeoneSitting(worldIn, pos);
            boolean invHasItem = !tile.getInventory().getStackInSlot(0).func_190926_b();
            boolean invIsMusic = invHasItem && tile.getInventory().getStackInSlot(0).func_77973_b() instanceof IMusic && tile.getInventory().getStackInSlot(0).func_82837_s();
            boolean canPlay = playerIn.func_184218_aH() && invIsMusic && PlacedInstrumentUtil.isPlayerSitting(worldIn, playerIn, pos) && PlayManager.playerNotPlaying(playerIn);
            boolean playerHasItem = !playerIn.func_184586_b(hand).func_190926_b();
            boolean bl = playerHasMusic = playerHasItem && playerIn.func_184586_b(hand).func_77973_b() instanceof IMusic && playerIn.func_184586_b(hand).func_82837_s();
            if (playerIn.func_70093_af() && !isOccupied) {
                ItemStack itemStack = tile.getInventory().getStackInSlot(0);
                tile.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
                if (!playerIn.field_71071_by.func_70441_a(itemStack)) {
                    if (!itemStack.func_190926_b()) {
                        BlockPiano.spawnEntityItem(worldIn, itemStack, pos);
                    }
                } else {
                    tile.syncToClient();
                    playerIn.field_71070_bA.func_75142_b();
                }
            } else {
                if (!playerIn.func_184218_aH() && invIsMusic && !isOccupied) {
                    return this.sitPiano(worldIn, pos, state, playerIn);
                }
                if (!playerIn.func_184218_aH() && !invHasItem) {
                    if (playerHasMusic) {
                        tile.getInventory().setStackInSlot(0, playerIn.func_184586_b(hand));
                        playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        tile.syncToClient();
                        playerIn.field_71070_bA.func_75142_b();
                    }
                } else if (canPlay && !playerIn.func_70093_af()) {
                    if (ServerCSDManager.canMXTunesPlay(playerIn)) {
                        ((EntitySittableBlock)playerIn.func_184187_bx()).setPlayID(PlayManager.playMusic(playerIn, pos));
                        ModCriteriaTriggers.PLAY_INSTRUMENT.trigger((EntityPlayerMP)playerIn, "spinet_piano");
                    } else {
                        ServerCSDManager.sendErrorViaChat(playerIn);
                    }
                }
            }
        } else if (playerIn.func_184187_bx() instanceof EntitySittableBlock && ((EntitySittableBlock)playerIn.func_184187_bx()).getBlockPos().equals((Object)pos)) {
            GuiJamOverlay.hudTimerReset();
        }
        return true;
    }

    @Override
    public int getPatch() {
        return SoundFontProxyManager.getIndexById("piano_mabinogi");
    }

    private boolean sitPiano(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        double xOffset = 0.0;
        double zOffset = 0.0;
        float yaw = 0.0f;
        if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.NORTH)) {
            xOffset = 1.375;
            zOffset = 0.0;
            yaw = 90.0f;
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.SOUTH)) {
            xOffset = -0.375;
            zOffset = 1.0;
            yaw = 270.0f;
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.EAST)) {
            xOffset = 1.0;
            zOffset = 1.375;
            yaw = 180.0f;
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.WEST)) {
            xOffset = 0.0;
            zOffset = -0.375;
            yaw = 0.0f;
        }
        return PlacedInstrumentUtil.sitOnBlock(worldIn, pos, playerIn, xOffset, 0.25, zOffset, yaw);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (state.func_177229_b(PART) == EnumPartType.RIGHT) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
            worldIn.func_175698_g(pos);
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        ArrayList list = Lists.newArrayList();
        list.add(PIANO_BODY_AABB);
        if (state.func_177229_b(PART) == EnumPartType.LEFT) {
            if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.NORTH)) {
                list.add(MUSIC_RACK_AABB_NW);
            } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.SOUTH)) {
                list.add(MUSIC_RACK_AABB_SE);
            } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.EAST)) {
                list.add(MUSIC_RACK_AABB_NE);
            } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.WEST)) {
                list.add(MUSIC_RACK_AABB_SW);
            }
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.NORTH)) {
            list.add(MUSIC_RACK_AABB_SW);
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.SOUTH)) {
            list.add(MUSIC_RACK_AABB_NE);
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.EAST)) {
            list.add(MUSIC_RACK_AABB_NW);
        } else if (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).equals((Object)EnumFacing.WEST)) {
            list.add(MUSIC_RACK_AABB_SE);
        }
        for (AxisAlignedBB axisalignedbb : list) {
            BlockPiano.addCollisionBoxToList(pos, entityBox, collidingBoxes, axisalignedbb);
        }
    }

    protected static void addCollisionBoxToList(@Nonnull BlockPos pos, AxisAlignedBB aaBBIn, List<AxisAlignedBB> listAABB, @Nullable AxisAlignedBB addedAABB) {
        AxisAlignedBB axisalignedbb;
        if (addedAABB != field_185506_k && aaBBIn.func_72326_a(axisalignedbb = Objects.requireNonNull(addedAABB).func_186670_a(pos))) {
            listAABB.add(axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PIANO_BODY_AABB;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)ModItems.ITEM_SPINET_PIANO);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.RIGHT && worldIn.func_180495_p(blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d())).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TilePiano tile = (TilePiano)worldIn.func_175625_s(pos);
        if (state.func_177229_b(PART) == EnumPartType.LEFT && tile != null && !tile.getInventory().getStackInSlot(0).func_190926_b()) {
            BlockPiano.spawnEntityItem(worldIn, tile.getInventory().getStackInSlot(0).func_77946_l(), pos);
            tile.func_145843_s();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(PART) == EnumPartType.RIGHT ? null : ModItems.ITEM_SPINET_PIANO;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (state.func_177229_b(PART) == EnumPartType.LEFT) {
            super.func_180653_a(worldIn, pos, state, chance, 0);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.RIGHT)).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf((meta & 4) > 0)) : this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.LEFT)).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public IBlockState func_176221_a(IBlockState stateIn, IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate;
        IBlockState stateOut = stateIn;
        if (stateIn.func_177229_b(PART) == EnumPartType.LEFT && (iblockstate = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)stateIn.func_177229_b((IProperty)field_185512_D)))).func_177230_c() == this) {
            stateOut = stateIn.func_177226_a((IProperty)OCCUPIED, iblockstate.func_177229_b((IProperty)OCCUPIED));
        }
        return stateOut;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (state.func_177229_b(PART) == EnumPartType.RIGHT) {
            i |= 8;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, PART, OCCUPIED});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(PART) == EnumPartType.LEFT;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePiano((EnumFacing)state.func_177229_b((IProperty)field_185512_D));
    }

    static void spawnEntityItem(World world, ItemStack stack, BlockPos pos) {
        BlockPiano.spawnEntityItem(world, stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    static void spawnEntityItem(World world, ItemStack stack, double x, double y, double z) {
        if (stack.func_190926_b()) {
            return;
        }
        float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, stack.func_77946_l());
        entityitem.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
        entityitem.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
        entityitem.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
        world.func_72838_d((Entity)entityitem);
    }

    public static enum EnumPartType implements IStringSerializable
    {
        RIGHT("right"),
        LEFT("left");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

