/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.parser;

import net.aeronica.libs.mml.parser.MMLUtil;

public class PartState {
    private int volume;
    private boolean volumeArcheAge;
    private int octave;
    private int mmlLength;
    private boolean dotted;
    private long runningTicks;
    private int perform;
    private boolean sustain;
    private boolean tied;
    private int prevPitch;

    PartState() {
        this.init();
    }

    public void init() {
        this.volume = 8;
        this.volumeArcheAge = false;
        this.octave = 4;
        this.mmlLength = 4;
        this.dotted = false;
        this.runningTicks = 0L;
        this.sustain = false;
        this.perform = 0;
        this.tied = false;
        this.prevPitch = -1;
    }

    public String toString() {
        return "@PartState: oct=" + this.octave + ", vol=" + this.volume + ", mLen=" + this.mmlLength + ", tie=" + this.tied + " dot=" + this.dotted + " ,runTicks=" + this.runningTicks + ", prevPitch=" + this.prevPitch;
    }

    public int getVolume() {
        if (this.volumeArcheAge) {
            return this.volume;
        }
        return MMLUtil.clamp(0, 127, this.volume * 127 / 15);
    }

    public void setVolume(int volume) {
        this.volume = MMLUtil.clamp(0, 127, volume);
        if (this.volume > 15) {
            this.volumeArcheAge = true;
        }
    }

    public int getOctave() {
        return this.octave;
    }

    public void setOctave(int octave) {
        this.octave = MMLUtil.clamp(0, 8, octave);
    }

    void downOctave() {
        this.octave = MMLUtil.clamp(0, 8, this.octave - 1);
    }

    void upOctave() {
        this.octave = MMLUtil.clamp(0, 8, this.octave + 1);
    }

    int getMMLLength() {
        return this.mmlLength;
    }

    boolean isDotted() {
        return this.dotted;
    }

    void setMMLLength(int mmlLength, boolean dotted) {
        this.mmlLength = MMLUtil.clamp(1, 64, mmlLength);
        this.dotted = dotted;
    }

    void accumulateTicks(long n) {
        this.runningTicks += n;
    }

    long getRunningTicks() {
        return this.runningTicks;
    }

    public int getPerform() {
        return this.perform;
    }

    public void setPerform(int perform) {
        this.perform = perform;
    }

    public boolean getSustain() {
        return this.sustain;
    }

    public void setSustain(int sustain) {
        this.sustain = sustain > 0;
    }

    public boolean isTied() {
        return this.tied;
    }

    public void setTied(boolean tied) {
        this.tied = tied;
    }

    public int getPrevPitch() {
        return this.prevPitch;
    }

    public void setPrevPitch(int prevPitch) {
        this.prevPitch = prevPitch;
    }
}

