/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.parser;

import javax.annotation.Nonnull;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;

public enum MMLUtil {

    public static final double PPQ = 480.0;
    public static final int MAX_TRACKS = 160;
    private static final int[] DOE_RE_MI = new int[]{50, 9, 11, 0, 2, 4, 5, 7};

    public static int getMIDINote(char rawNote, int mmlOctave) {
        int doreNote = 0;
        doreNote = rawNote >= 'A' && rawNote <= 'G' ? rawNote - 64 : rawNote - 96;
        int octave = mmlOctave * 12 + 12;
        return octave + DOE_RE_MI[doreNote];
    }

    public static int getMIDINote(char rawNote, int mmlOctave, boolean rest) {
        int midiNote = MMLUtil.getMIDINote(rawNote, mmlOctave);
        return midiNote + (rest ? 128 : 0);
    }

    public static int smartClampMIDI(int midiNoteIn) {
        int midiNoteClamped = midiNoteIn;
        while (midiNoteClamped < 0 || midiNoteClamped > 127) {
            if (midiNoteClamped < 0) {
                midiNoteClamped += 12;
            }
            if (midiNoteClamped <= 127) continue;
            midiNoteClamped -= 12;
        }
        return midiNoteClamped;
    }

    public static int clamp(int min, int max, int value) {
        return Math.max(Math.min(max, value), min);
    }

    public static Patch packedPreset2Patch(int packedPatchIn) {
        int program = packedPatchIn & 0x7F;
        int bank = 0;
        if (packedPatchIn > 127) {
            bank = (packedPatchIn & 0x1FFF80) >>> 7;
        }
        return new Patch(bank, program);
    }

    public static int preset2PackedPreset(int bankIn, int programIn) {
        int bank = bankIn < 128 ? bankIn : 128;
        int patch = programIn & 0x7F;
        return (bank << 7) + patch;
    }

    public static int patch2PackedPreset(Patch patchIn) {
        return MMLUtil.preset2PackedPreset(patchIn.getBank(), patchIn.getProgram());
    }

    public static int instrument2PackedPreset(@Nonnull Instrument instrument) {
        boolean isPercussionSet = instrument.toString().contains("Drumkit:");
        int bank = instrument.getPatch().getBank() >>> 7;
        int program = instrument.getPatch().getProgram();
        return isPercussionSet ? MMLUtil.preset2PackedPreset(128, program) : MMLUtil.preset2PackedPreset(bank, program);
    }
}

