/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.parser;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.aeronica.libs.mml.parser.InstState;
import net.aeronica.libs.mml.parser.MMLLexer;
import net.aeronica.libs.mml.parser.MMLNavigator;
import net.aeronica.libs.mml.parser.MMLObject;
import net.aeronica.libs.mml.parser.MMLUtil;
import net.aeronica.libs.mml.parser.PartState;
import net.aeronica.libs.mml.parser.TempState;
import net.aeronica.libs.mml.util.DataByteBuffer;
import net.aeronica.libs.mml.util.IndexBuffer;

public class MMLParser {
    private final InstState instState = new InstState();
    private final PartState partState = new PartState();
    private final TempState tempState = new TempState();
    private long longestRunningTicks = 0L;
    private final List<MMLObject> mmlObjects = new ArrayList<MMLObject>(1000);
    private final StringBuilder sb = new StringBuilder();
    private final String mmlString;

    public MMLParser(String mmlString) {
        this.mmlString = mmlString;
        this.parse();
    }

    public List<MMLObject> getMmlObjects() {
        return this.mmlObjects;
    }

    private void parse() {
        DataByteBuffer dataBuffer = new DataByteBuffer(this.mmlString.getBytes(StandardCharsets.US_ASCII));
        IndexBuffer elementBuffer = new IndexBuffer(dataBuffer.getLength(), true);
        MMLLexer parser = new MMLLexer();
        parser.parse(dataBuffer, elementBuffer);
        MMLNavigator navigator = new MMLNavigator(dataBuffer, elementBuffer);
        if (!navigator.hasNext()) {
            return;
        }
        do {
            switch (navigator.type()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.doCommand(navigator);
                    break;
                }
                case 2: {
                    this.doLength(navigator);
                    break;
                }
                case 8: 
                case 9: {
                    this.doOctaveUpDown(navigator);
                    break;
                }
                case 13: {
                    this.doMIDI(navigator);
                    break;
                }
                case 10: {
                    this.doNote(navigator);
                    break;
                }
                case 15: {
                    this.doTie(navigator);
                    break;
                }
                case 16: {
                    this.doRest(navigator);
                    break;
                }
                case 18: {
                    this.doBegin(navigator);
                    break;
                }
                case 19: {
                    this.doChord(navigator);
                    break;
                }
                case 20: {
                    this.doEnd(navigator);
                    break;
                }
                default: {
                    navigator.next();
                }
            }
        } while (navigator.hasNext());
        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.DONE).longestPartTicks(this.getLongestRunningTicks()).minVolume(this.instState.getMinVolume()).maxVolume(this.instState.getMaxVolume()).text("EOF").build());
        this.processTiedNotes();
    }

    private void processTiedNotes() {
        boolean lastTied = false;
        for (int idx = this.mmlObjects.size() - 1; idx > 0; --idx) {
            MMLObject mo = this.mmlObjects.get(idx);
            if (mo.getType() == MMLObject.Type.PART || mo.getType() == MMLObject.Type.STOP || mo.getType() == MMLObject.Type.REST) {
                lastTied = false;
            }
            if (mo.getType() != MMLObject.Type.NOTE) continue;
            if (mo.isTied() && !lastTied) {
                lastTied = true;
                mo.setDoNoteOn(false);
                continue;
            }
            if (mo.isTied() && lastTied) {
                mo.setDoNoteOn(false);
                mo.setDoNoteOff(false);
                continue;
            }
            if (mo.isTied() || !lastTied) continue;
            lastTied = false;
            mo.setDoNoteOff(false);
        }
    }

    private void doBegin(MMLNavigator nav) {
        this.collectDataToText(nav.asString());
        this.instState.init();
        this.partState.init();
        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.INIT).startingTicks(this.partState.getRunningTicks()).text(nav.asString()).build());
        this.clearText();
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doChord(MMLNavigator nav) {
        this.collectDataToText(nav.anyChar());
        this.instState.collectDurationTicks(this.partState.getRunningTicks());
        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.PART).text(this.getText()).startingTicks(0L).build());
        this.clearText();
        this.partState.init();
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doEnd(MMLNavigator nav) {
        this.collectDataToText(nav.anyChar());
        this.instState.collectDurationTicks(this.partState.getRunningTicks());
        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.STOP).cumulativeTicks(this.partState.getRunningTicks()).startingTicks(this.partState.getRunningTicks()).text(this.getText()).build());
        this.setLongestRunningTicks(this.instState.getLongestDurationTicks());
        this.clearText();
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doCommand(MMLNavigator nav) {
        char anyChar = nav.anyChar();
        byte type = nav.type();
        if (nav.hasNext()) {
            nav.next();
            if (nav.type() == 17 && nav.asInt() >= 0) {
                int value = nav.asInt();
                this.collectDataToText(anyChar);
                this.collectDataToText(value);
                switch (type) {
                    case 1: {
                        this.instState.setInstrument(nav.asInt());
                        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.INST).instrument(this.instState.getInstrument()).startingTicks(this.partState.getRunningTicks()).text(this.getText()).build());
                        this.clearText();
                        break;
                    }
                    case 3: {
                        this.partState.setOctave(value);
                        break;
                    }
                    case 4: {
                        this.partState.setPerform(value);
                        break;
                    }
                    case 5: {
                        this.partState.setSustain(value);
                        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.SUSTAIN).sustain(this.partState.getSustain()).startingTicks(this.partState.getRunningTicks()).text(this.getText()).build());
                        break;
                    }
                    case 6: {
                        this.instState.setTempo(value);
                        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.TEMPO).tempo(this.instState.getTempo()).startingTicks(this.partState.getRunningTicks()).text(this.getText()).build());
                        break;
                    }
                    case 7: {
                        this.partState.setVolume(value);
                        break;
                    }
                }
            }
        }
    }

    private void doLength(MMLNavigator nav) {
        this.collectDataToText(nav.anyChar());
        if (nav.hasNext()) {
            nav.next();
            if (nav.type() == 17 && nav.asInt() >= 0) {
                int value = nav.asInt();
                this.collectDataToText(value);
                this.partState.setMMLLength(value, false);
                if (nav.hasNext()) {
                    nav.next();
                }
                if (nav.type() == 14) {
                    this.collectDataToText(nav.anyChar());
                    this.partState.setMMLLength(value, true);
                    if (nav.hasNext()) {
                        nav.next();
                    }
                }
            }
        }
    }

    private void doTie(MMLNavigator nav) {
        this.collectDataToText(nav.anyChar());
        byte peekValue = this.peekNextType(nav);
        if (peekValue == 10 || peekValue == 13) {
            this.partState.setTied(true);
        }
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doOctaveUpDown(MMLNavigator nav) {
        this.collectDataToText(nav.anyChar());
        if (nav.type() == 8) {
            this.partState.upOctave();
        } else if (nav.type() == 9) {
            this.partState.downOctave();
        }
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doNote(MMLNavigator nav) {
        byte nextType;
        int prevPitch = this.partState.getPrevPitch();
        this.tempState.init();
        this.collectDataToText(nav.asChar());
        this.tempState.setPitch(MMLUtil.getMIDINote(nav.asChar(), this.partState.getOctave()));
        this.tempState.setDuration(this.partState.getMMLLength());
        this.tempState.setDotted(this.partState.isDotted());
        do {
            if ((nextType = this.peekNextType(nav)) != 11 && nextType != 12) continue;
            nav.next();
            this.collectDataToText(nav.anyChar());
            this.tempState.setAccidental(nav.type());
            nextType = this.peekNextType(nav);
        } while (nextType == 11 || nextType == 12);
        if (nextType == 17) {
            nav.next();
            this.collectDataToText(nav.asInt());
            this.tempState.setDuration(nav.asInt());
            this.tempState.setDotted(false);
            nextType = this.peekNextType(nav);
        }
        if (nextType == 14) {
            nav.next();
            this.collectDataToText(nav.anyChar());
            this.tempState.setDotted(true);
        }
        long lengthTicks = this.durationTicks(this.tempState.getDuration(), this.tempState.isDotted());
        boolean tiedNote = this.tempState.getPitch() == prevPitch && this.partState.isTied();
        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.NOTE).midiNote(this.tempState.getPitch()).startingTicks(this.partState.getRunningTicks()).lengthTicks(lengthTicks).volume(this.partState.getVolume()).tied(tiedNote).text(this.getText()).build());
        this.partState.accumulateTicks(lengthTicks);
        this.partState.setPrevPitch(this.tempState.getPitch());
        this.partState.setTied(false);
        this.clearText();
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doMIDI(MMLNavigator nav) {
        boolean tiedNote;
        byte nextType;
        int prevPitch = this.partState.getPrevPitch();
        this.tempState.init();
        this.collectDataToText(nav.anyChar());
        this.tempState.setPitch(-3);
        this.tempState.setDuration(this.partState.getMMLLength());
        this.tempState.setDotted(this.partState.isDotted());
        do {
            if ((nextType = this.peekNextType(nav)) != 11 && nextType != 12) continue;
            nav.next();
            nextType = this.peekNextType(nav);
        } while (nextType == 11 || nextType == 12);
        if (nextType == 17) {
            nav.next();
            this.collectDataToText(nav.asInt());
            this.tempState.setPitch(nav.asInt() + 12);
            nextType = this.peekNextType(nav);
        }
        if (nextType == 14) {
            nav.next();
            this.collectDataToText(nav.anyChar());
        }
        long lengthTicks = this.durationTicks(this.tempState.getDuration(), this.tempState.isDotted());
        boolean bl = tiedNote = this.tempState.getPitch() == prevPitch && this.partState.isTied();
        if (this.tempState.getPitch() >= 0) {
            this.addMMLObj(new MMLObject.Builder(MMLObject.Type.NOTE).midiNote(this.tempState.getPitch()).startingTicks(this.partState.getRunningTicks()).lengthTicks(lengthTicks).volume(this.partState.getVolume()).tied(tiedNote).text(this.getText()).build());
        }
        this.partState.accumulateTicks(lengthTicks);
        this.partState.setPrevPitch(this.tempState.getPitch());
        this.partState.setTied(false);
        this.clearText();
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private void doRest(MMLNavigator nav) {
        byte nextType;
        this.partState.setTied(false);
        this.partState.setPrevPitch(-2);
        this.collectDataToText(nav.anyChar());
        this.tempState.init();
        this.tempState.setDuration(this.partState.getMMLLength());
        this.tempState.setDotted(this.partState.isDotted());
        do {
            if ((nextType = this.peekNextType(nav)) != 11 && nextType != 12) continue;
            nav.next();
            this.collectDataToText(nav.anyChar());
            nextType = this.peekNextType(nav);
        } while (nextType == 11 || nextType == 12);
        if (nextType == 17) {
            nav.next();
            this.collectDataToText(nav.asInt());
            this.tempState.setDuration(nav.asInt());
            this.tempState.setDotted(false);
            nextType = this.peekNextType(nav);
        }
        if (nextType == 14) {
            nav.next();
            this.collectDataToText(nav.anyChar());
            this.tempState.setDotted(true);
        }
        long lengthTicks = this.durationTicks(this.tempState.getDuration(), this.tempState.isDotted());
        this.addMMLObj(new MMLObject.Builder(MMLObject.Type.REST).startingTicks(this.partState.getRunningTicks()).lengthTicks(lengthTicks).text(this.getText()).build());
        this.partState.accumulateTicks(lengthTicks);
        this.clearText();
        if (nav.hasNext()) {
            nav.next();
        }
    }

    private byte peekNextType(MMLNavigator nav) {
        byte elementType = 21;
        if (nav.hasNext()) {
            nav.next();
            elementType = nav.type();
            nav.previous();
        }
        return elementType;
    }

    private void addMMLObj(MMLObject mmlObject) {
        this.mmlObjects.add(mmlObject);
    }

    private long durationTicks(int mmlNoteLength, boolean dottedLEN) {
        double dot = dottedLEN ? 15.0 : 10.0;
        return (long)(4.0 / (double)mmlNoteLength * dot / 10.0 * 480.0);
    }

    public long getLongestRunningTicks() {
        return this.longestRunningTicks;
    }

    public void setLongestRunningTicks(long longestRunningTicks) {
        if (longestRunningTicks > this.longestRunningTicks) {
            this.longestRunningTicks = longestRunningTicks;
        }
    }

    private void collectDataToText(char c) {
        this.sb.append(c);
    }

    private void collectDataToText(String s) {
        this.sb.append(s);
    }

    private void collectDataToText(int number) {
        this.sb.append(number);
    }

    private String getText() {
        return this.sb.toString();
    }

    private void clearText() {
        try {
            this.sb.delete(0, Math.max(this.sb.length(), 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

