/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.parser;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.aeronica.libs.mml.util.DataByteBuffer;
import net.aeronica.libs.mml.util.IndexBuffer;

public class MMLNavigator {
    private DataByteBuffer buffer = null;
    private IndexBuffer elementBuffer = null;
    private int elementIndex = 0;

    public MMLNavigator(DataByteBuffer buffer, IndexBuffer elementBuffer) {
        this.buffer = buffer;
        this.elementBuffer = elementBuffer;
    }

    public boolean hasNext() {
        return this.elementIndex < this.elementBuffer.getCount();
    }

    public void next() {
        ++this.elementIndex;
    }

    public void previous() {
        --this.elementIndex;
    }

    public int position() {
        return this.elementBuffer.getPosition(this.elementIndex);
    }

    public int length() {
        return this.elementBuffer.getLength(this.elementIndex);
    }

    public byte type() {
        return this.elementBuffer.getType(this.elementIndex);
    }

    public String asString() {
        byte elementType = this.elementBuffer.getType(this.elementIndex);
        if (elementType == 18) {
            try {
                return new String(this.buffer.getData(), this.elementBuffer.getPosition(this.elementIndex), this.elementBuffer.getLength(this.elementIndex), StandardCharsets.US_ASCII.name());
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        return "";
    }

    public int asInt() {
        byte numberType = this.elementBuffer.getType(this.elementIndex);
        if (numberType == 17) {
            try {
                String number = new String(this.buffer.getData(), this.elementBuffer.getPosition(this.elementIndex), this.elementBuffer.getLength(this.elementIndex), StandardCharsets.US_ASCII.name());
                int length = number.length();
                if (length >= 1 && length <= 5) {
                    return Integer.parseInt(number);
                }
            }
            catch (UnsupportedEncodingException | NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public char asChar() {
        if (10 == this.type()) {
            return (char)this.buffer.getByte(this.elementBuffer.getPosition(this.elementIndex));
        }
        return '\u0000';
    }

    public char anyChar() {
        return (char)this.buffer.getByte(this.elementBuffer.getPosition(this.elementIndex));
    }
}

