/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.libs.mml.midi;

import java.nio.ByteBuffer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;

public class MIDIHelper {
    private MIDIHelper() {
    }

    public static MidiEvent createControlChangeEvent(int channel, int controller, int value, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(176, channel, controller & 0x7F, value & 0x7F);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createProgramChangeEvent(int channel, int value, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(192, channel, value, 0);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createBankSelectEventMSB(int channel, int value, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage(176, channel, 0, value >> 7);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createBankSelectEventLSB(int channel, int value, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage(176, channel, 32, value & 0x7F);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createNoteOnEvent(int channel, int pitch, int velocity, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(144, channel, pitch, velocity);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createNoteOffEvent(int channel, int pitch, int velocity, long tick) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(128, channel, pitch, velocity);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createTempoMetaEvent(int tempo, long tick) throws InvalidMidiDataException {
        MetaMessage msg = new MetaMessage();
        byte[] data = ByteBuffer.allocate(4).putInt(60000000 / tempo).array();
        data[0] = data[1];
        data[1] = data[2];
        data[2] = data[3];
        msg.setMessage(81, data, 3);
        return new MidiEvent(msg, tick);
    }

    public static MidiEvent createTextMetaEvent(String text, long tick) throws InvalidMidiDataException {
        MetaMessage msg = new MetaMessage();
        byte[] data = text.getBytes();
        msg.setMessage(1, data, data.length);
        return new MidiEvent(msg, tick);
    }
}

