/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.mixin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinProcessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.transformer.Proxy;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;
import zone.rong.mixinbooter.Context;
import zone.rong.mixinbooter.ILateMixinLoader;
import zone.rong.mixinbooter.IMixinConfigHijacker;
import zone.rong.mixinbooter.MixinBooterPlugin;
import zone.rong.mixinbooter.MixinLoader;
import zone.rong.mixinbooter.fix.MixinFixer;

@Mixin(value={LoadController.class}, remap=false)
public class LoadControllerMixin {
    @Shadow
    private Loader loader;

    @Inject(method={"distributeStateMessage(Lnet/minecraftforge/fml/common/LoaderState;[Ljava/lang/Object;)V"}, at={@At(value="HEAD")})
    private void beforeConstructing(LoaderState state, Object[] eventData, CallbackInfo ci) throws Throwable {
        if (state == LoaderState.CONSTRUCTING) {
            Set<String> unconventionalConfigs;
            Class<?> clazz;
            ModClassLoader modClassLoader = (ModClassLoader)eventData[0];
            ASMDataTable asmDataTable = (ASMDataTable)eventData[1];
            for (ModContainer container : this.loader.getActiveModList()) {
                modClassLoader.addFile(container.getSource());
            }
            Set interfaceData = asmDataTable.getAll(ILateMixinLoader.class.getName().replace('.', '/'));
            HashSet<ILateMixinLoader> lateLoaders = new HashSet<ILateMixinLoader>();
            Set annotatedData = asmDataTable.getAll(MixinLoader.class.getName());
            if (!annotatedData.isEmpty()) {
                for (ASMDataTable.ASMData annotated : annotatedData) {
                    try {
                        clazz = Class.forName(annotated.getClassName());
                        MixinBooterPlugin.LOGGER.info("Loading annotated late loader [{}] for its mixins.", (Object)clazz.getName());
                        Object instance = clazz.newInstance();
                        if (!(instance instanceof ILateMixinLoader)) continue;
                        lateLoaders.add((ILateMixinLoader)instance);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Unexpected error.", t);
                    }
                }
            }
            if (!interfaceData.isEmpty()) {
                for (Object itf : interfaceData) {
                    try {
                        clazz = Class.forName(itf.getClassName().replace('/', '.'));
                        MixinBooterPlugin.LOGGER.info("Loading late loader [{}] for its mixins.", (Object)clazz.getName());
                        lateLoaders.add((ILateMixinLoader)clazz.newInstance());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Unexpected error.", t);
                    }
                }
                Collection presentMods = this.loader.getActiveModList().stream().map(ModContainer::getModId).collect(Collectors.toSet());
                for (ILateMixinLoader lateLoader : lateLoaders) {
                    for (String mixinConfig : lateLoader.getMixinConfigs()) {
                        Context context = new Context(mixinConfig, presentMods);
                        if (!lateLoader.shouldMixinConfigQueue(context)) continue;
                        IMixinConfigHijacker hijacker = MixinBooterPlugin.getHijacker(mixinConfig);
                        if (hijacker != null) {
                            MixinBooterPlugin.LOGGER.info("Mixin configuration [{}] intercepted by [{}].", (Object)mixinConfig, (Object)hijacker.getClass().getName());
                            continue;
                        }
                        MixinBooterPlugin.LOGGER.info("Adding [{}] mixin configuration.", (Object)mixinConfig);
                        Mixins.addConfiguration(mixinConfig);
                        lateLoader.onMixinConfigQueued(context);
                    }
                }
            }
            if (!(unconventionalConfigs = MixinFixer.retrieveLateMixinConfigs()).isEmpty()) {
                MixinBooterPlugin.LOGGER.info("Appending unconventional mixin configurations...");
                for (String unconventionalConfig : unconventionalConfigs) {
                    IMixinConfigHijacker hijacker = MixinBooterPlugin.getHijacker(unconventionalConfig);
                    if (hijacker != null) {
                        MixinBooterPlugin.LOGGER.info("Mixin configuration [{}] intercepted by [{}].", (Object)unconventionalConfig, (Object)hijacker.getClass().getName());
                        continue;
                    }
                    MixinBooterPlugin.LOGGER.info("Adding [{}] mixin configuration.", (Object)unconventionalConfig);
                    Mixins.addConfiguration(unconventionalConfig);
                }
            }
            Field delegatedTransformersField = MixinServiceLaunchWrapper.class.getDeclaredField("delegatedTransformers");
            delegatedTransformersField.setAccessible(true);
            delegatedTransformersField.set(MixinService.getService(), null);
            IMixinProcessor processor = Proxy.transformer.getProcessor();
            Method selectMethod = processor.getClass().getDeclaredMethod("select", MixinEnvironment.class);
            selectMethod.setAccessible(true);
            selectMethod.invoke((Object)processor, MixinEnvironment.getCurrentEnvironment());
        }
    }
}

