/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyMeta
extends PropertyHelper<Integer> {
    private final ImmutableSet<Integer> allowedValues;
    private static final Integer[] VALUES = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};

    protected PropertyMeta(String name, List<Integer> valid_meta) {
        super(name, Integer.class);
        HashSet set = Sets.newHashSet();
        for (Integer v : valid_meta) {
            if (v < 0 || v > 15) {
                throw new IllegalArgumentException("Invalid meta value");
            }
            set.add(VALUES[v]);
        }
        this.allowedValues = ImmutableSet.copyOf((Collection)set);
    }

    public Collection<Integer> func_177700_c() {
        return this.allowedValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyMeta && super.equals(obj)) {
            PropertyMeta propertymeta = (PropertyMeta)((Object)obj);
            return this.allowedValues.equals(propertymeta.allowedValues);
        }
        return false;
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.allowedValues.hashCode();
    }

    public static PropertyMeta create(String name, List<Integer> valid_vals) {
        return new PropertyMeta(name, valid_vals);
    }

    public Optional<Integer> func_185929_b(String value) {
        try {
            Integer integer = Integer.valueOf(value);
            return this.allowedValues.contains((Object)integer) ? Optional.of((Object)VALUES[integer]) : Optional.absent();
        }
        catch (NumberFormatException var3) {
            return Optional.absent();
        }
    }

    public String getName(Integer value) {
        return value.toString();
    }

    public Integer fromMeta(int m) {
        return VALUES[m];
    }
}

