/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class SolidBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public SolidBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            SolidBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            Variant var = new Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            Object model;
            Object mod;
            boolean isTinted = sb.isTinted(this.def);
            if (sb.textures.size() > 1 || isTinted) {
                mod = new ModelObjectCube();
                ((ModelObjectCube)mod).textures.down = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(0));
                ((ModelObjectCube)mod).textures.up = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(1));
                ((ModelObjectCube)mod).textures.north = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(2));
                ((ModelObjectCube)mod).textures.south = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(3));
                ((ModelObjectCube)mod).textures.west = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(4));
                ((ModelObjectCube)mod).textures.east = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(5));
                ((ModelObjectCube)mod).textures.particle = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(2));
                if (isTinted) {
                    ((ModelObjectCube)mod).parent = "westerosblocks:block/tinted/cube";
                }
                model = mod;
            } else {
                mod = new ModelObjectCubeAll();
                ((ModelObjectCubeAll)mod).textures.all = SolidBlockModelExport.getTextureID(sb.getTextureByIndex(0));
                model = mod;
            }
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, model);
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant=%s", sb.meta), tintres);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Texture {
        public String down;
        public String up;
        public String north;
        public String south;
        public String west;
        public String east;
        public String particle;
    }

    public static class ModelObjectCube {
        public String parent = "block/cube";
        public Texture textures = new Texture();
    }

    public static class TextureAll {
        public String all;
    }

    public static class ModelObjectCubeAll {
        public String parent = "block/cube_all";
        public TextureAll textures = new TextureAll();
    }

    public static class Variant {
        public String model;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

