/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.blocks.WCSlabBlock;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class SlabBlockModelExport
extends ModelExport {
    private WCSlabBlock blk;
    private WesterosBlockDef def;

    public SlabBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.blk = (WCSlabBlock)blk;
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            SlabBlockModelExport.addNLSString(this.blk.func_150002_b(sb.meta) + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        Variant var;
        StateObject so = new StateObject();
        String bn = this.def.getBlockName(0);
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            var = new Variant();
            var.model = "westerosblocks:" + bn + "_" + sb.meta + "_top";
            so.variants.put(String.format("half=top,variant=%d", sb.meta), var);
            var = new Variant();
            var.model = "westerosblocks:" + bn + "_" + sb.meta + "_bottom";
            so.variants.put(String.format("half=bottom,variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(bn, so);
        so = new StateObject();
        bn = this.def.getBlockName(1);
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            var = new Variant();
            var.model = "westerosblocks:" + bn + "_" + sb.meta;
            so.variants.put(String.format("variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(bn, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            boolean isTinted = sb.isTinted(this.def);
            boolean isOccluded = sb.ambientOcclusion != null ? sb.ambientOcclusion : true;
            ModelObjectCube mod = new ModelObjectCube(isOccluded, isTinted);
            mod.textures.down = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            mod.textures.up = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            mod.textures.north = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            mod.textures.south = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(3));
            mod.textures.west = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(4));
            mod.textures.east = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(5));
            mod.textures.particle = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(3));
            this.writeBlockModelFile(this.def.getBlockName(1) + "_" + sb.meta, mod);
            ModelObjectHalfLower modl = new ModelObjectHalfLower(isOccluded, isTinted);
            modl.textures.bottom = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            modl.textures.top = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            modl.textures.side = modl.textures.particle = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            this.writeBlockModelFile(this.def.getBlockName(0) + "_" + sb.meta + "_bottom", modl);
            ModelObjectHalfUpper modu = new ModelObjectHalfUpper(isOccluded, isTinted);
            modu.textures.bottom = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            modu.textures.top = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            modu.textures.side = modu.textures.particle = SlabBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            this.writeBlockModelFile(this.def.getBlockName(0) + "_" + sb.meta + "_top", modu);
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.getBlockName(0) + "_" + sb.meta + "_bottom";
            this.writeItemModelFile(this.def.getBlockName(0) + "_" + sb.meta, mo);
            this.writeItemModelFile(this.def.getBlockName(1) + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant=%s", sb.meta), tintres);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class TextureSlab {
        public String bottom;
        public String top;
        public String side;
        public String particle;
    }

    public static class ModelObjectHalfUpper {
        public String parent;
        public TextureSlab textures = new TextureSlab();

        public ModelObjectHalfUpper(boolean ambientocclusion, boolean tinted) {
            this.parent = ambientocclusion ? (tinted ? "westerosblocks:block/tinted/upper_slab" : "block/upper_slab") : (tinted ? "westerosblocks:block/tintednoocclusion/upper_slab" : "westerosblocks:block/noocclusion/upper_slab");
        }
    }

    public static class ModelObjectHalfLower {
        public String parent;
        public TextureSlab textures = new TextureSlab();

        public ModelObjectHalfLower(boolean ambientocclusion, boolean tinted) {
            this.parent = ambientocclusion ? (tinted ? "westerosblocks:block/tinted/half_slab" : "block/half_slab") : (tinted ? "westerosblocks:block/tintednoocclusion/half_slab" : "westerosblocks:block/noocclusion/half_slab");
        }
    }

    public static class Texture {
        public String down;
        public String up;
        public String north;
        public String south;
        public String west;
        public String east;
        public String particle;
    }

    public static class ModelObjectCube {
        public String parent;
        public Texture textures = new Texture();

        public ModelObjectCube(boolean ambientocclusion, boolean tinted) {
            this.parent = ambientocclusion ? (tinted ? "westerosblocks:block/tinted/cube" : "block/cube") : (tinted ? "westerosblocks:block/tintednoocclusion/cube" : "westerosblocks:block/noocclusion/cube");
        }
    }

    public static class Variant {
        public String model;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

