/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.blocks.WCPaneBlock;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;

public class PaneBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;
    private boolean[] legacy_model = new boolean[16];
    private boolean[] bars_model = new boolean[16];

    public PaneBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            PaneBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
            this.legacy_model[sb.meta] = ((WCPaneBlock)blk).isLegacyModel(sb.meta);
            this.bars_model[sb.meta] = ((WCPaneBlock)blk).isBarsModel(sb.meta);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            boolean is_legacy = this.legacy_model[sb.meta];
            boolean is_bars = this.bars_model[sb.meta];
            WhenRec wnone = new WhenRec();
            wnone.east = wnone.west = Boolean.FALSE;
            wnone.south = wnone.west;
            wnone.north = wnone.west;
            wnone.variant = Integer.toString(sb.meta);
            if (!is_bars) {
                States ps = new States();
                ps.when.variant = Integer.toString(sb.meta);
                ps.apply.model = "westerosblocks:" + this.def.blockName + "_post_" + sb.meta;
                so.multipart.add(ps);
            }
            SideStates ssn = new SideStates();
            WhenRec wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.north = true;
            ssn.when.OR.add(wr);
            if (is_legacy || is_bars) {
                ssn.when.OR.add(wnone);
            }
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_" + sb.meta;
            ssn.apply.uvlock = true;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.east = true;
            ssn.when.OR.add(wr);
            if (is_legacy || is_bars) {
                ssn.when.OR.add(wnone);
            }
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_" + sb.meta;
            ssn.apply.uvlock = true;
            ssn.apply.y = 90;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.south = true;
            ssn.when.OR.add(wr);
            if (is_legacy || is_bars) {
                ssn.when.OR.add(wnone);
            }
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_alt_" + sb.meta;
            ssn.apply.uvlock = true;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.west = true;
            ssn.when.OR.add(wr);
            if (is_legacy || is_bars) {
                ssn.when.OR.add(wnone);
            }
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_side_alt_" + sb.meta;
            ssn.apply.uvlock = true;
            ssn.apply.y = 90;
            so.multipart.add(ssn);
            if (is_bars) continue;
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.north = false;
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_noside_" + sb.meta;
            ssn.apply.uvlock = true;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.east = false;
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_noside_alt_" + sb.meta;
            ssn.apply.uvlock = true;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.south = false;
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_noside_alt_" + sb.meta;
            ssn.apply.y = 90;
            ssn.apply.uvlock = true;
            so.multipart.add(ssn);
            ssn = new SideStates();
            wr = new WhenRec();
            wr.variant = Integer.toString(sb.meta);
            wr.west = false;
            ssn.when.OR.add(wr);
            ssn.apply.model = "westerosblocks:" + this.def.blockName + "_noside_" + sb.meta;
            ssn.apply.uvlock = true;
            ssn.apply.y = 270;
            so.multipart.add(ssn);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            boolean is_bars = this.bars_model[sb.meta];
            if (!is_bars) {
                ModelObjectPost mod = new ModelObjectPost();
                mod.textures.pane = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(0));
                mod.textures.edge = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(1));
                this.writeBlockModelFile(this.def.blockName + "_post_" + sb.meta, mod);
            }
            ModelObjectSide smod = new ModelObjectSide();
            smod.textures.pane = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            smod.textures.edge = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            if (is_bars) {
                smod.parent = "westerosblocks:block/untinted/bars_side";
            }
            this.writeBlockModelFile(this.def.blockName + "_side_" + sb.meta, smod);
            ModelObjectSideAlt samod = new ModelObjectSideAlt();
            samod.textures.pane = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            samod.textures.edge = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            if (is_bars) {
                samod.parent = "westerosblocks:block/untinted/bars_side_alt";
            }
            this.writeBlockModelFile(this.def.blockName + "_side_alt_" + sb.meta, samod);
            if (!is_bars) {
                ModelObjectNoSide nsmod = new ModelObjectNoSide();
                nsmod.textures.pane = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(0));
                this.writeBlockModelFile(this.def.blockName + "_noside_" + sb.meta, nsmod);
                ModelObjectNoSideAlt nsamod = new ModelObjectNoSideAlt();
                nsamod.textures.pane = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(0));
                this.writeBlockModelFile(this.def.blockName + "_noside_alt_" + sb.meta, nsamod);
            }
            ModelObject mo = new ModelObject();
            mo.textures.layer0 = PaneBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
        }
    }

    public static class ModelObject {
        public String parent = "item/generated";
        public TextureLayer0 textures = new TextureLayer0();
    }

    public static class TextureLayer0 {
        public String layer0;
    }

    public static class Texture {
        public String edge;
        public String pane;
    }

    public static class ModelObjectNoSideAlt {
        public String parent = "block/pane_noside_alt";
        public Texture textures = new Texture();
    }

    public static class ModelObjectNoSide {
        public String parent = "block/pane_noside";
        public Texture textures = new Texture();
    }

    public static class ModelObjectSideAlt {
        public String parent = "block/pane_side_alt";
        public Texture textures = new Texture();
    }

    public static class ModelObjectSide {
        public String parent = "block/pane_side";
        public Texture textures = new Texture();
    }

    public static class ModelObjectPost {
        public String parent = "block/pane_post";
        public Texture textures = new Texture();
    }

    public static class Apply {
        String model;
        Integer x;
        Integer y;
        Boolean uvlock;
    }

    public static class WhenRec {
        String variant;
        Boolean north;
        Boolean south;
        Boolean west;
        Boolean east;
        public List<WhenRec> OR;
    }

    public static class SideStates
    extends States {
        SideStates() {
            this.when.OR = new ArrayList<WhenRec>();
        }
    }

    public static class States {
        public WhenRec when = new WhenRec();
        public Apply apply = new Apply();
    }

    public static class StateObject {
        public List<States> multipart = new ArrayList<States>();
    }
}

