/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.westeroscraft.westerosblocks.WesterosBlockDef;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import net.minecraft.block.Block;

public abstract class ModelExport {
    private File destdir;
    private File blockstatedir;
    private File blockmodeldir;
    private File itemmodeldir;
    private static Properties nls = new Properties();
    private static Map<String, List<TintOver>> tintoverrides = new HashMap<String, List<TintOver>>();

    public ModelExport(Block block, WesterosBlockDef def, File dest) {
        this.destdir = dest;
        this.blockstatedir = new File(this.destdir, "assets/westerosblocks/blockstates");
        this.blockstatedir.mkdirs();
        this.blockmodeldir = new File(this.destdir, "assets/westerosblocks/models/block");
        this.blockmodeldir.mkdirs();
        this.itemmodeldir = new File(this.destdir, "assets/westerosblocks/models/item");
        this.itemmodeldir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlockStateFile(String blockname, Object obj) throws IOException {
        File f = new File(this.blockstatedir, blockname + ".json");
        try (FileWriter fos = null;){
            fos = new FileWriter(f);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            gson.toJson(obj, (Appendable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlockModelFile(String model, Object obj) throws IOException {
        File f = new File(this.blockmodeldir, model + ".json");
        try (FileWriter fos = null;){
            fos = new FileWriter(f);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            gson.toJson(obj, (Appendable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeItemModelFile(String model, Object obj) throws IOException {
        File f = new File(this.itemmodeldir, model + ".json");
        try (FileWriter fos = null;){
            fos = new FileWriter(f);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            gson.toJson(obj, (Appendable)fos);
        }
    }

    public static String getTextureID(String id) {
        if (id.indexOf(58) >= 0) {
            return id;
        }
        return "westerosblocks:blocks/" + id;
    }

    public abstract void doBlockStateExport() throws IOException;

    public abstract void doModelExports() throws IOException;

    public static void addNLSString(String id, String val) {
        nls.put(id, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNLSFile(File dest) throws IOException {
        File tgt = new File(dest, "assets/westerosblocks/lang");
        tgt.mkdirs();
        try (PrintStream fw = null;){
            fw = new PrintStream(new File(tgt, "en_US.lang"));
            Properties tmp = new Properties(){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
            tmp.putAll((Map<?, ?>)nls);
            tmp.store(fw, null);
        }
    }

    public static void addTintingOverride(String blockname, String cond, String txtfile) {
        List<TintOver> blst = tintoverrides.get(blockname);
        if (blst == null) {
            blst = new ArrayList<TintOver>();
            tintoverrides.put(blockname, blst);
        }
        TintOver to = new TintOver();
        to.cond = cond;
        to.txt = txtfile;
        blst.add(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDynmapOverridesFile(File dest) throws IOException {
        File tgt = new File(dest, "assets/westerosblocks/dynmap");
        tgt.mkdirs();
        try (PrintStream fw = null;){
            fw = new PrintStream(new File(tgt, "blockstateoverrides.json"));
            fw.println("{");
            fw.println("  \"overrides\": {");
            fw.println("      \"westerosblocks\": {");
            fw.println("       }");
            fw.println("   },");
            fw.println("  \"tinting\": {");
            fw.println("      \"westerosblocks\": {");
            boolean first1 = true;
            for (Map.Entry<String, List<TintOver>> br : tintoverrides.entrySet()) {
                if (!first1) {
                    fw.println("          ,");
                }
                fw.println("          \"" + br.getKey() + "\": [");
                boolean first2 = true;
                for (TintOver toe : br.getValue()) {
                    if (!first2) {
                        fw.println("              ,");
                    }
                    if (toe.cond != null && !toe.cond.equals("")) {
                        fw.println("              { \"state\": \"" + toe.cond + "\", \"colormap\": [ \"" + toe.txt + "\" ] }");
                    } else {
                        fw.println("              { \"colormap\": [ \"" + toe.txt + "\" ] }");
                    }
                    first2 = false;
                }
                fw.println("          ]");
                first1 = false;
            }
            fw.println("       }");
            fw.println("   }");
            fw.println("}");
        }
    }

    private static class TintOver {
        String cond;
        String txt;

        private TintOver() {
        }
    }
}

