/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class LeavesBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public LeavesBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            LeavesBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            Variant var = new Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            boolean isTinted = sb.isTinted(this.def);
            ModelObjectLeaves mod = new ModelObjectLeaves();
            mod.elements[0].faces.put("down", new Faces("#end", "down", isTinted));
            mod.elements[0].faces.put("up", new Faces("#end", "up", isTinted));
            mod.elements[0].faces.put("north", new Faces("#side", "north", isTinted));
            mod.elements[0].faces.put("south", new Faces("#side", "south", isTinted));
            mod.elements[0].faces.put("west", new Faces("#side", "west", isTinted));
            mod.elements[0].faces.put("east", new Faces("#side", "east", isTinted));
            mod.textures.end = LeavesBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            mod.textures.particle = mod.textures.side = LeavesBlockModelExport.getTextureID(sb.getTextureByIndex(3));
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, mod);
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class Faces {
        int[] uv = new int[]{0, 0, 16, 16};
        String texture;
        Integer tintindex;
        String cullface;

        public Faces(String txt, String face, boolean isTinted) {
            this.texture = txt;
            this.cullface = face;
            this.tintindex = isTinted ? Integer.valueOf(0) : null;
        }
    }

    public static class Elements {
        int[] from = new int[]{0, 0, 0};
        int[] to = new int[]{16, 16, 16};
        Map<String, Faces> faces = new HashMap<String, Faces>();
    }

    public static class Texture {
        public String end;
        public String side;
        public String particle;
    }

    public static class ModelObjectLeaves {
        public String parent = "block/block";
        public Texture textures = new Texture();
        public Elements[] elements = new Elements[]{new Elements()};
    }

    public static class Variant {
        public String model;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

