/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class FurnaceBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public FurnaceBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            FurnaceBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String bn = this.def.blockName + "_" + sb.meta + "_lit";
            so.variants.put(String.format("facing=north,lit=true,variant=%d", sb.meta), new Variant(bn, 0));
            so.variants.put(String.format("facing=south,lit=true,variant=%d", sb.meta), new Variant(bn, 180));
            so.variants.put(String.format("facing=west,lit=true,variant=%d", sb.meta), new Variant(bn, 270));
            so.variants.put(String.format("facing=east,lit=true,variant=%d", sb.meta), new Variant(bn, 90));
            bn = this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("facing=north,lit=false,variant=%d", sb.meta), new Variant(bn, 0));
            so.variants.put(String.format("facing=south,lit=false,variant=%d", sb.meta), new Variant(bn, 180));
            so.variants.put(String.format("facing=west,lit=false,variant=%d", sb.meta), new Variant(bn, 270));
            so.variants.put(String.format("facing=east,lit=false,variant=%d", sb.meta), new Variant(bn, 90));
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            boolean isTinted = sb.isTinted(this.def);
            ModelObjectCubeAll mod = new ModelObjectCubeAll();
            mod.textures.top = FurnaceBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            mod.textures.side = FurnaceBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            mod.textures.front = FurnaceBlockModelExport.getTextureID(sb.getTextureByIndex(3));
            if (isTinted) {
                mod.parent = "westerosblocks:block/tinted/orientable";
            }
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta + "_lit", mod);
            mod = new ModelObjectCubeAll();
            mod.textures.top = FurnaceBlockModelExport.getTextureID(sb.getTextureByIndex(1));
            mod.textures.side = FurnaceBlockModelExport.getTextureID(sb.getTextureByIndex(2));
            mod.textures.front = FurnaceBlockModelExport.getTextureID(sb.getTextureByIndex(4));
            if (isTinted) {
                mod.parent = "westerosblocks:block/tinted/orientable";
            }
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, mod);
            ModelObject mo = new ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant=%s", sb.meta), tintres);
        }
    }

    public static class ModelObject {
        public String parent;
    }

    public static class TextureOrient {
        public String top;
        public String front;
        public String side;
    }

    public static class ModelObjectCubeAll {
        public String parent = "block/orientable";
        public TextureOrient textures = new TextureOrient();
    }

    public static class Variant {
        public String model;
        public Integer y;

        public Variant(String bn, int y) {
            this.model = "westerosblocks:" + bn;
            if (y != 0) {
                this.y = y;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

