/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.CuboidBlockModelExport;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;

public class CuboidNSEWUDBlockModelExport
extends CuboidBlockModelExport {
    public CuboidNSEWUDBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        CuboidBlockModelExport.StateObject so = new CuboidBlockModelExport.StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            CuboidBlockModelExport.Variant var = new CuboidBlockModelExport.Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("facing=north,variant=%d", sb.meta), var);
            var = new CuboidBlockModelExport.Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            var.y = 90;
            so.variants.put(String.format("facing=east,variant=%d", sb.meta), var);
            var = new CuboidBlockModelExport.Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            var.y = 180;
            so.variants.put(String.format("facing=south,variant=%d", sb.meta), var);
            var = new CuboidBlockModelExport.Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            var.y = 270;
            so.variants.put(String.format("facing=west,variant=%d", sb.meta), var);
            var = new CuboidBlockModelExport.Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            var.x = 270;
            so.variants.put(String.format("facing=up,variant=%d", sb.meta), var);
            var = new CuboidBlockModelExport.Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            var.x = 90;
            so.variants.put(String.format("facing=down,variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            boolean isTinted = sb.isTinted(this.def);
            this.doCuboidModel(sb, sb.meta, sb.meta + 6, this.def.blockName, isTinted);
            CuboidBlockModelExport.ModelObject mo = new CuboidBlockModelExport.ModelObject();
            mo.parent = "westerosblocks:block/" + this.def.blockName + "_" + sb.meta;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant=%s", sb.meta), tintres);
        }
    }
}

