/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class CrossBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public CrossBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            CrossBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            Variant var = new Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            String tintres;
            ModelObjectCross mod = new ModelObjectCross();
            mod.textures.cross = CrossBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            boolean isTinted = sb.isTinted(this.def);
            if (isTinted) {
                mod.parent = "block/tinted_cross";
            }
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, mod);
            ModelObject mo = new ModelObject();
            mo.textures.layer0 = mod.textures.cross;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
            if (!isTinted || (tintres = this.def.getBlockColorMapResource(sb)) == null) continue;
            ModelExport.addTintingOverride(this.def.blockName, String.format("variant=%s", sb.meta), tintres);
        }
    }

    public static class ModelObject {
        public String parent = "item/generated";
        public TextureLayer0 textures = new TextureLayer0();
    }

    public static class TextureLayer0 {
        public String layer0;
    }

    public static class TextureCross {
        public String cross;
    }

    public static class ModelObjectCross {
        public String parent = "block/cross";
        public TextureCross textures = new TextureCross();
    }

    public static class Variant {
        public String model;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

