/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class CropBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public CropBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        for (WesterosBlockDef.Subblock sb : def.subBlocks) {
            CropBlockModelExport.addNLSString("tile." + def.blockName + "_" + sb.meta + ".name", sb.label);
        }
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            Variant var = new Variant();
            var.model = "westerosblocks:" + this.def.blockName + "_" + sb.meta;
            so.variants.put(String.format("variant=%d", sb.meta), var);
        }
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            ModelObjectCrop mod = new ModelObjectCrop();
            mod.textures.crop = CropBlockModelExport.getTextureID(sb.getTextureByIndex(0));
            this.writeBlockModelFile(this.def.blockName + "_" + sb.meta, mod);
            ModelObject mo = new ModelObject();
            mo.textures.layer0 = mod.textures.crop;
            this.writeItemModelFile(this.def.blockName + "_" + sb.meta, mo);
        }
    }

    public static class ModelObject {
        public String parent = "item/generated";
        public TextureLayer0 textures = new TextureLayer0();
    }

    public static class TextureLayer0 {
        public String layer0;
    }

    public static class TextureCrop {
        public String crop;
    }

    public static class ModelObjectCrop {
        public String parent = "block/crop";
        public TextureCrop textures = new TextureCrop();
    }

    public static class Variant {
        public String model;
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

