/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.modelexport;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.modelexport.ModelExport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class BedBlockModelExport
extends ModelExport {
    private WesterosBlockDef def;

    public BedBlockModelExport(Block blk, WesterosBlockDef def, File dest) {
        super(blk, def, dest);
        this.def = def;
        BedBlockModelExport.addNLSString("tile." + def.blockName + ".name", def.subBlocks.get((int)0).label);
    }

    @Override
    public void doBlockStateExport() throws IOException {
        StateObject so = new StateObject();
        String bn = "westerosblocks:" + this.def.blockName;
        so.variants.put("facing=north,part=foot", new Variant(bn, "foot", 180));
        so.variants.put("facing=east,part=foot", new Variant(bn, "foot", 270));
        so.variants.put("facing=south,part=foot", new Variant(bn, "foot", 0));
        so.variants.put("facing=west,part=foot", new Variant(bn, "foot", 90));
        so.variants.put("facing=north,part=head", new Variant(bn, "head", 180));
        so.variants.put("facing=east,part=head", new Variant(bn, "head", 270));
        so.variants.put("facing=south,part=head", new Variant(bn, "head", 0));
        so.variants.put("facing=west,part=head", new Variant(bn, "head", 90));
        this.writeBlockStateFile(this.def.blockName, so);
    }

    @Override
    public void doModelExports() throws IOException {
        WesterosBlockDef.Subblock sb = this.def.subBlocks.get(0);
        ModelObjectBedHead mod = new ModelObjectBedHead();
        mod.textures.bedtop = BedBlockModelExport.getTextureID(sb.getTextureByIndex(0));
        mod.textures.bedend = BedBlockModelExport.getTextureID(sb.getTextureByIndex(4));
        mod.textures.bedside = BedBlockModelExport.getTextureID(sb.getTextureByIndex(2));
        this.writeBlockModelFile(this.def.blockName + "_head", mod);
        ModelObjectBedFoot modf = new ModelObjectBedFoot();
        modf.textures.bedtop = BedBlockModelExport.getTextureID(sb.getTextureByIndex(1));
        modf.textures.bedend = BedBlockModelExport.getTextureID(sb.getTextureByIndex(5));
        modf.textures.bedside = BedBlockModelExport.getTextureID(sb.getTextureByIndex(3));
        this.writeBlockModelFile(this.def.blockName + "_foot", modf);
        ModelObject mo = new ModelObject();
        mo.parent = "westerosblocks:item/bed_item";
        mo.textures.bedtop = mod.textures.bedtop;
        mo.textures.bedend = mod.textures.bedend;
        mo.textures.bedside = mod.textures.bedside;
        mo.textures.bedtop2 = modf.textures.bedtop;
        mo.textures.bedend2 = modf.textures.bedend;
        mo.textures.bedside2 = modf.textures.bedside;
        this.writeItemModelFile(this.def.blockName, mo);
    }

    public static class ModelObject {
        public String parent;
        public Texture textures = new Texture();
    }

    public static class Texture {
        public String bedtop;
        public String bedend;
        public String bedside;
        public String bedtop2;
        public String bedend2;
        public String bedside2;
    }

    public static class ModelObjectBedFoot {
        public String parent = "westerosblocks:block/bed_foot";
        public Texture textures = new Texture();
    }

    public static class ModelObjectBedHead {
        public String parent = "westerosblocks:block/bed_head";
        public Texture textures = new Texture();
    }

    public static class Variant {
        public String model;
        public Integer y;

        public Variant(String bn, String ext, int y) {
            this.model = bn + "_" + ext;
            if (y != 0) {
                this.y = y;
            }
        }
    }

    public static class StateObject {
        public Map<String, Variant> variants = new HashMap<String, Variant>();
    }
}

