/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.commands;

import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.network.PTimeCmdMsgPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class PTimeCommand
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();
    public static final int ticksAtMidnight = 18000;
    public static final int ticksPerDay = 24000;
    public static final int ticksPerHour = 1000;
    private static boolean relative_off = true;
    private static long time_off = 0L;

    public PTimeCommand() {
        this.aliases.add("ptime");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "ptime";
    }

    public String func_71518_a(ICommandSender sender) {
        return "ptime [reset|day|night|dawn|17:30|4pm|4000ticks]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (!world.field_72995_K) {
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                Long off = null;
                boolean rel = true;
                if (args.length != 1) {
                    throw new WrongUsageException("Requires one argument", new Object[0]);
                }
                String timearg = args[0];
                if (timearg.startsWith("@")) {
                    rel = false;
                    timearg = timearg.substring(1);
                }
                try {
                    off = PTimeCommand.timestrToTick(timearg);
                }
                catch (IllegalArgumentException x) {
                    throw new WrongUsageException(x.getMessage(), new Object[0]);
                }
                if (off == null) {
                    off = 0L;
                    rel = true;
                    sender.func_145747_a((ITextComponent)new TextComponentString("Resetting player time to world time"));
                } else if (rel) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Setting player time relative to world time"));
                    long curtime = player.func_71121_q().func_72820_D();
                    off = (off - curtime + 24000L) % 24000L;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Setting player time to fixed"));
                }
                PTimeCmdMsgPacket.sendCmdMessage(player, rel, off.intValue());
            } else {
                WesterosBlocks.log.info("Command only usable by player");
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public static Long timestrToTick(String timestr) throws IllegalArgumentException {
        switch (timestr = timestr.toLowerCase()) {
            case "reset": 
            case "normal": 
            case "default": {
                return null;
            }
            case "sunrise": 
            case "dawn": {
                return 23000L;
            }
            case "daystart": 
            case "day": {
                return 0L;
            }
            case "morning": {
                return 1000L;
            }
            case "midday": 
            case "noon": {
                return 6000L;
            }
            case "afternoon": {
                return 9000L;
            }
            case "sunset": 
            case "dusk": 
            case "sundown": 
            case "nightfall": {
                return 12000L;
            }
            case "nightstart": 
            case "night": {
                return 14000L;
            }
            case "midnight": {
                return 18000L;
            }
        }
        if (timestr.matches("^[0-9]+ti?c?k?s?$")) {
            return Long.parseLong(timestr.replaceAll("[^0-9]", "")) % 24000L;
        }
        if (timestr.matches("^[0-9]{2}[^0-9]?[0-9]{2}$")) {
            String pname = timestr.replaceAll("[^0-9]", "");
            if (pname.length() != 4) {
                throw new IllegalArgumentException("Bad 24 hour time - " + timestr);
            }
            return PTimeCommand.hoursMinutesToTicks(Integer.parseInt(pname.substring(0, 2)), Integer.parseInt(pname.substring(2, 4)));
        }
        if (timestr.matches("^[0-9]{1,2}([^0-9]?[0-9]{2})?(pm|am)$")) {
            String ptime = timestr.replaceAll("[^0-9]", "");
            int hrs = 0;
            int mins = 0;
            switch (ptime.length()) {
                case 4: {
                    hrs = Integer.parseInt(ptime.substring(0, 2));
                    mins = Integer.parseInt(ptime.substring(2, 4));
                    break;
                }
                case 3: {
                    hrs = Integer.parseInt(ptime.substring(0, 1));
                    mins = Integer.parseInt(ptime.substring(1, 3));
                    break;
                }
                case 1: 
                case 2: {
                    hrs = Integer.parseInt(ptime);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad 12 hour time - " + timestr);
                }
            }
            if (timestr.endsWith("pm") && hrs != 12) {
                hrs += 12;
            } else if (timestr.endsWith("am") && hrs == 12) {
                hrs -= 12;
            }
            return PTimeCommand.hoursMinutesToTicks(hrs, mins);
        }
        throw new IllegalArgumentException("Bad time - " + timestr);
    }

    public static long hoursMinutesToTicks(int hours, int min) {
        return (18000 + hours * 1000 + min * 1000 / 60) % 24000;
    }

    public static void setTimeOffset(boolean relative, int offset_ticks) {
        relative_off = relative;
        time_off = offset_ticks;
    }

    public static long processWorldTime(long wt) {
        if (wt >= 0L) {
            wt = relative_off ? (wt + 24000L + time_off) % 24000L : wt - wt % 24000L + time_off;
        }
        return wt;
    }

    public static long processTotalWorldTime(long twt) {
        return twt;
    }
}

