/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCTrapDoorBlock
extends BlockTrapDoor
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;
    private boolean locked = false;

    protected WCTrapDoorBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        def.doStandardContructorSettings((Block)this);
        WesterosBlockDef.Subblock sb = def.subBlocks.get(0);
        String t = def.getType(sb.meta);
        if (t != null) {
            String[] toks;
            for (String tok : toks = t.split(",")) {
                if (!tok.equals("locked:true")) continue;
                this.locked = true;
            }
        }
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, ItemBlock.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems((Block)this, tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd, 0, this.def.alphaRender ? TransparencyMode.TRANSPARENT : TransparencyMode.OPAQUE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.locked) {
            return false;
        }
        state = state.func_177231_a((IProperty)field_176283_b);
        worldIn.func_180501_a(pos, state, 2);
        this.func_185731_a(playerIn, worldIn, pos, (Boolean)state.func_177229_b((IProperty)field_176283_b));
        return true;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        IBlockState down;
        if (((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof BlockLadder) {
            return down.func_177229_b((IProperty)BlockLadder.field_176382_a) == state.func_177229_b((IProperty)field_176284_a);
        }
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCTrapDoorBlock(def)};
        }
    }
}

