/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.google.common.collect.Lists;
import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCSolidBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    protected static PropertyMeta new_variant = null;
    protected WesterosBlockDef def;
    private boolean isSolidOpaque = true;
    private PropertyMeta variant;

    protected WCSolidBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.isSolidOpaque = !def.nonOpaque;
        this.def = def;
        def.doStandardContructorSettings(this);
        this.func_149672_a(def.getSoundType());
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems(this, tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : (this.isSolidOpaque ? BlockRenderLayer.SOLID : BlockRenderLayer.CUTOUT);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isSolidOpaque;
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.def.hasCollisionBoxes();
    }

    public boolean func_149730_j(IBlockState state) {
        return !this.def.hasCollisionBoxes();
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd, 0, this.def.alphaRender ? TransparencyMode.TRANSPARENT : TransparencyMode.OPAQUE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.variant});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)this.variant)).intValue());
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (this.def.hasCollisionBoxes()) {
            List<WesterosBlockDef.BoundingBox> boxes = this.def.getCollisionBoxList(this.func_176201_c(state));
            for (WesterosBlockDef.BoundingBox bb : boxes) {
                WCSolidBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb.getAABB());
            }
        } else {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        WesterosBlockDef.BoundingBox bb;
        if (this.def.hasCollisionBoxes() && (bb = this.def.getBoundingBox(state, source, pos)) != null) {
            return bb.getAABB();
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        WesterosBlockDef.BoundingBox bb;
        if (this.def.hasCollisionBoxes() && (bb = this.def.getBoundingBox(state, source, pos)) != null) {
            return bb.getAABB();
        }
        return field_185505_j;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        if (!this.def.hasCollisionBoxes()) {
            return super.func_180636_a(blockState, worldIn, pos, start, end);
        }
        ArrayList list = Lists.newArrayList();
        for (WesterosBlockDef.BoundingBox bb : this.def.getCollisionBoxList(this.func_176201_c(blockState))) {
            list.add(this.func_185503_a(pos, start, end, bb.getAABB()));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block connector = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return connector instanceof BlockWall || connector instanceof BlockFence || connector instanceof BlockPane;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material getMaterial(int meta) {
        return this.def.getMaterial(meta);
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (!def.validateMetaValues(null, null)) {
                return null;
            }
            new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            return new Block[]{new WCSolidBlock(def)};
        }
    }
}

