/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.google.common.collect.Lists;
import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.properties.PropertyMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCCuboidBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    protected static PropertyMeta new_variant = null;
    protected WesterosBlockDef def;
    public PropertyMeta variant;
    protected int meta_per_sub;

    protected WCCuboidBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        this.func_149672_a(def.getSoundType());
        this.meta_per_sub = 1;
        def.doStandardContructorSettings(this);
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.def.getStandardCreativeItems(this, tab, list);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.def.getFlammability(world, pos, face);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.def.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.def.alphaRender ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        WesterosBlockDef def = this.getWBDefinition();
        String blkname = def.getBlockName(0);
        def.defaultRegisterTextures(mtd);
        def.registerPatchTextureBlock(mtd, 6, TransparencyMode.TRANSPARENT, this.meta_per_sub);
        for (int meta = 0; meta < 16; ++meta) {
            List<WesterosBlockDef.Cuboid> cl = def.getCuboidList(meta);
            if (cl == null) continue;
            CuboidBlockModel mod = md.addCuboidModel(blkname);
            for (WesterosBlockDef.Cuboid c : cl) {
                if ("crossed".equals(c.shape)) {
                    mod.addCrossedPatches((double)c.xMin, (double)c.yMin, (double)c.zMin, (double)c.xMax, (double)c.yMax, (double)c.zMax, c.sideTextures[0]);
                    continue;
                }
                mod.addCuboid((double)c.xMin, (double)c.yMin, (double)c.zMin, (double)c.xMax, (double)c.yMax, (double)c.zMax, c.sideTextures);
            }
            mod.setMetaValue(meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rnd) {
        this.def.randomDisplayTick(stateIn, worldIn, pos, rnd);
        super.func_180655_c(stateIn, worldIn, pos, rnd);
    }

    protected BlockStateContainer func_180661_e() {
        if (new_variant != null) {
            this.variant = new_variant;
            new_variant = null;
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.variant});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.variant, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.variant);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return this.def.colorMultiplier();
    }

    @Override
    public IProperty<?>[] getNonRenderingProperties() {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        WesterosBlockDef.BoundingBox bb = this.def.getBoundingBox(state, source, pos);
        return bb.getAABB();
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        WesterosBlockDef.BoundingBox bb = this.def.getBoundingBox(state, source, pos);
        return bb.getAABB();
    }

    public List<WesterosBlockDef.Cuboid> getCuboidList(int meta) {
        List<WesterosBlockDef.Cuboid> rslt = this.def.getCuboidList(meta);
        if (rslt == null) {
            rslt = Collections.emptyList();
        }
        return rslt;
    }

    public void setBoundingBoxFromCuboidList(int meta) {
        List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(meta);
        if (cl == null) {
            cl = Collections.emptyList();
        }
        float xmin = 100.0f;
        float ymin = 100.0f;
        float zmin = 100.0f;
        float xmax = -100.0f;
        float ymax = -100.0f;
        float zmax = -100.0f;
        for (WesterosBlockDef.Cuboid c : cl) {
            if (c.xMin < xmin) {
                xmin = c.xMin;
            }
            if (c.yMin < ymin) {
                ymin = c.yMin;
            }
            if (c.zMin < zmin) {
                zmin = c.zMin;
            }
            if (c.xMax > xmax) {
                xmax = c.xMax;
            }
            if (c.yMax > ymax) {
                ymax = c.yMax;
            }
            if (!(c.zMax > zmax)) continue;
            zmax = c.zMax;
        }
        this.def.setBoundingBox(meta, xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(this.func_176201_c(state));
        if (cl == null) {
            cl = Collections.emptyList();
        }
        for (WesterosBlockDef.Cuboid bb : cl) {
            AxisAlignedBB aabb = new AxisAlignedBB((double)bb.xMin, (double)bb.yMin, (double)bb.zMin, (double)bb.xMax, (double)bb.yMax, (double)bb.zMax);
            WCCuboidBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(this.func_176201_c(blockState));
        if (cl == null) {
            cl = Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (WesterosBlockDef.Cuboid bb : cl) {
            AxisAlignedBB aabb = new AxisAlignedBB((double)bb.xMin, (double)bb.yMin, (double)bb.zMin, (double)bb.xMax, (double)bb.yMax, (double)bb.zMax);
            list.add(this.func_185503_a(pos, start, end, aabb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos blockPos, @Nullable Entity entity) {
        return this.def.getSoundType(blockState.func_177230_c().func_176201_c(blockState));
    }

    public Material func_149688_o(IBlockState blockState) {
        return this.def.getMaterial(blockState.func_177230_c().func_176201_c(blockState));
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (!def.validateMetaValues(null, null)) {
                return null;
            }
            new_variant = PropertyMeta.create("variant", def.getDefinedBaseMeta());
            return new Block[]{new WCCuboidBlock(def)};
        }
    }
}

