/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.IResting;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.RenderConstants;

public class EntityRedPanda
extends AbstractZawaLand
implements IResting {
    public float lyingTimer;
    public float defaultTimer;
    private boolean leaning = false;

    public EntityRedPanda(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.7f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.25));
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.RED_PANDA;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.RED_PANDA, RenderConstants.RED_PANDA_LYING});
    }

    @Override
    @Nullable
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.RED_PANDA_BABY, RenderConstants.RED_PANDA_BABY_SLEEPING});
    }

    @Override
    public boolean playerAwoken() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.2f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityRedPanda(this.field_70170_p);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getLying()) {
            this.lyingTimer += 0.07f;
            this.defaultTimer = 0.0f;
            this.setBlink(true);
        } else {
            this.lyingTimer = 0.0f;
            this.defaultTimer += 0.07f;
        }
    }

    public boolean isLeaning() {
        return !this.func_70631_g_() && this.leaning;
    }

    @Override
    public boolean getLying() {
        return !this.func_70631_g_() && this.getStillTicks() >= 30 && !this.leaning && !BookwormUtils.isEntityMoving((Entity)this);
    }
}

