/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.zawamod.client.render.entity.RenderKoala;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.entity.core.IResting;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderInfo;
import org.zawamod.util.status.StatusClimbing;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/zawamod/entity/land/EntityKoala;", "Lorg/zawamod/entity/base/AbstractZawaLand;", "Lorg/zawamod/entity/core/IResting;", "w", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "besideClimbable", "", "createChild", "ageable", "Lnet/minecraft/entity/EntityAgeable;", "createNavigator", "Lnet/minecraft/pathfinding/PathNavigate;", "worldIn", "fall", "", "distance", "", "damageMultiplier", "getIconList", "Lorg/zawamod/util/DataItem;", "getLying", "getPack", "Lorg/zawamod/entity/core/AnimalPack;", "getRenderInfo", "Lorg/zawamod/util/RenderInfo;", "isFoodItem", "stack", "Lnet/minecraft/item/ItemStack;", "isOnLadder", "isValidBlock", "block", "Lnet/minecraft/block/Block;", "onUpdate", "zawa"})
public final class EntityKoala
extends AbstractZawaLand
implements IResting {
    private boolean besideClimbable;

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState iBlockState = this.field_70170_p.func_180495_p(this.func_180425_c().func_177972_a(facing));
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(position.offset(facing))");
            Block block = iBlockState.func_177230_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"world.getBlockState(position.offset(facing)).block");
            if (!this.isValidBlock(block)) continue;
            this.besideClimbable = this.field_70123_F;
        }
    }

    private final boolean isValidBlock(Block block) {
        return block instanceof BlockLog || block instanceof BlockLeaves || block instanceof BlockPlanks;
    }

    public boolean func_70617_f_() {
        return this.besideClimbable && ZAWAConfig.serverOptions.canClimb;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @NotNull
    public EntityKoala createChild(@NotNull EntityAgeable ageable) {
        Intrinsics.checkParameterIsNotNull((Object)ageable, (String)"ageable");
        World world = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        return new EntityKoala(world);
    }

    @Override
    @NotNull
    public AnimalPack getPack() {
        AnimalPack animalPack = AnimalPackManager.KOALA;
        Intrinsics.checkExpressionValueIsNotNull((Object)animalPack, (String)"KOALA");
        return animalPack;
    }

    @Override
    @NotNull
    public RenderInfo getRenderInfo() {
        return RenderKoala.INFO;
    }

    @Override
    public boolean isFoodItem(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)ZAWAItems.EUCALYPTUS) || Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)Item.func_150898_a((Block)((Block)Blocks.field_150362_t)));
    }

    @Override
    @NotNull
    public DataItem getIconList() {
        return new DataItem(CollectionsKt.listOf((Object)new StatusClimbing()));
    }

    @Override
    @NotNull
    protected PathNavigate func_175447_b(@NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        return (PathNavigate)new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    public boolean getLying() {
        return this.getStillTicks() > 30;
    }

    public EntityKoala(@NotNull World w) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        super(w);
        this.func_70105_a(0.8f, 0.9f);
    }
}

