/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.general;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.general.EntityEggShell;
import org.zawamod.util.ZAWAUtils;

public class EntityZAWAEgg
extends EntityAgeable {
    protected static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(EntityZAWAEgg.class, (DataSerializer)DataSerializers.field_187194_d);
    private int shakeTime;
    private int nextShake;
    private int existingTime;
    private boolean isShaking = false;
    protected int time_hatch = 1000;
    public int crackState = 0;

    public EntityZAWAEgg(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.2f, 0.2f);
    }

    public EntityZAWAEgg(Entity parent) {
        this(parent.field_70170_p);
        this.setType(EntityList.func_191301_a((Entity)parent).toString());
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)"");
    }

    public String getType() {
        return (String)this.field_70180_af.func_187225_a(TYPE);
    }

    public int getTimeToHatch() {
        return this.time_hatch;
    }

    public boolean isShaking() {
        return this.isShaking;
    }

    public int getShakeTime() {
        return this.shakeTime;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public void setType(String type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("Type", this.getType());
        compound.func_74768_a("existingTime", this.existingTime);
        compound.func_74774_a("ParentA", this.getParentA());
        compound.func_74774_a("ParentB", this.getParentB());
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74774_a("Trait", (byte)this.getTrait().ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74779_i("Type"));
        this.existingTime = compound.func_74762_e("existingTime");
        this.setParentA(compound.func_74771_c("ParentA"));
        this.setParentB(compound.func_74771_c("ParentB"));
        this.setVariant(compound.func_74762_e("Variant"));
        this.setAnimalTrait(ZAWAUtils.getTraitFromValue(compound.func_74771_c("Trait")));
    }

    public byte getParentA() {
        return this.getEntityData().func_74771_c("ParentA");
    }

    public byte getParentB() {
        return this.getEntityData().func_74771_c("ParentB");
    }

    public void setParentA(byte b) {
        this.getEntityData().func_74774_a("ParentA", b);
    }

    public void setParentB(byte b) {
        this.getEntityData().func_74774_a("ParentB", b);
    }

    public int getVariant() {
        return this.getEntityData().func_74762_e("Variant");
    }

    public void setVariant(int variant) {
        this.getEntityData().func_74768_a("Variant", variant);
    }

    public AnimalData.Traits getTrait() {
        return ZAWAUtils.getTraitFromValue(this.getEntityData().func_74771_c("Trait"));
    }

    public void setAnimalTrait(AnimalData.Traits trait) {
        this.getEntityData().func_74774_a("Trait", (byte)trait.ordinal());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.existingTime;
        if ((float)this.existingTime > (float)this.time_hatch / 1.8f) {
            ++this.nextShake;
            if (this.nextShake > 20) {
                this.isShaking = true;
                if (this.field_70122_E) {
                    this.field_70181_x = 0.21f;
                }
            }
            if (this.isShaking) {
                ++this.shakeTime;
                if (this.shakeTime > 10) {
                    this.isShaking = false;
                    this.nextShake = 0;
                    this.shakeTime = 0;
                }
            }
        }
        if ((float)this.existingTime > (float)this.time_hatch / 1.2f) {
            this.crackState = 3;
        } else if ((float)this.existingTime > (float)this.time_hatch / 1.5f) {
            this.crackState = 2;
        } else if ((float)this.existingTime > (float)this.time_hatch / 1.8f) {
            this.crackState = 1;
        }
        if (this.existingTime >= this.time_hatch) {
            Entity e;
            if (this.field_70170_p.field_72995_K) {
                EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.func_70681_au().nextGaussian() * 0.02;
                    double d1 = this.func_70681_au().nextGaussian() * 0.02;
                    double d2 = this.func_70681_au().nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.func_70681_au().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.func_70681_au().nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.func_70681_au().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
            if (!this.field_70170_p.field_72995_K && !this.getType().isEmpty() && (e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.getType()), (World)this.field_70170_p)) != null) {
                e.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (e instanceof EntityAgeable) {
                    ((EntityAgeable)e).func_70873_a(-24000);
                }
                if (e instanceof AbstractZawaLand) {
                    AbstractZawaLand eb = (AbstractZawaLand)e;
                    eb.setParentA(this.getParentA());
                    eb.setParentB(this.getParentB());
                    eb.setTrait(this.getTrait());
                    ModuleManager.VARIANT.setVariant(eb, this.getVariant());
                }
                this.field_70170_p.func_72838_d(e);
                EntityEggShell shellA = new EntityEggShell(this.field_70170_p);
                EntityEggShell shellB = new EntityEggShell(this.field_70170_p);
                shellA.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                shellB.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                shellA.setTop(true);
                shellA.setType(this.getType());
                shellB.setType(this.getType());
                shellA.field_70181_x = 0.1f;
                shellA.field_70159_w = 0.1f * this.func_70681_au().nextFloat() * (float)(this.func_70681_au().nextBoolean() ? 1 : -1);
                shellA.field_70179_y = 0.1f * this.func_70681_au().nextFloat() * (float)(this.func_70681_au().nextBoolean() ? 1 : -1);
                shellB.field_70181_x = 0.1f;
                shellB.field_70159_w = 0.1f * this.func_70681_au().nextFloat() * (float)(this.func_70681_au().nextBoolean() ? 1 : -1);
                shellB.field_70179_y = 0.1f * this.func_70681_au().nextFloat() * (float)(this.func_70681_au().nextBoolean() ? 1 : -1);
                this.field_70170_p.func_72838_d((Entity)shellA);
                this.field_70170_p.func_72838_d((Entity)shellB);
            }
            this.func_70106_y();
        }
    }

    public int getExistingTime() {
        return this.existingTime;
    }
}

