/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.core.modules.type;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.zawamod.ZAWAMain;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.configuration.ZAWAModuleConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.UsableHandler;
import org.zawamod.entity.core.UsableObject;
import org.zawamod.entity.core.modules.AnimalModule;
import org.zawamod.event.ZAWAEnrichEvent;

public class EnrichmentModule
extends AnimalModule<AbstractZawaLand> {
    private ZAWAModuleConfig.ModuleOption<Boolean> enabled = new ZAWAModuleConfig.ModuleOption<Boolean>(".Enabled", "Enrichment", true).register();
    private ZAWAModuleConfig.ModuleOption<Integer> enrichmentCooldown = new ZAWAModuleConfig.ModuleOption<Integer>("Enrichment Cool-down", "Enrichment", 40).register();
    private ZAWAModuleConfig.ModuleOption<Float> maxEnrichment = new ZAWAModuleConfig.ModuleOption<Float>("Max Enrichment", "Enrichment", Float.valueOf(20.0f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> lowEnrichmentDamageStart = new ZAWAModuleConfig.ModuleOption<Float>("How low enrichment has to be for damage", "Enrichment", Float.valueOf(0.0f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> depressionDamage = new ZAWAModuleConfig.ModuleOption<Float>("Enrichment damage per tick", "Enrichment", Float.valueOf(0.1f)).register();
    public static final String ENRICHMENT_COOLDOWN = "enrichmentCooldown";
    public static final String SEARCH_COOLDOWN = "searchCooldownEnrichment";
    public static final String SOCIAL_COUNT = "socialCount";
    public static final String NEXT_GAIN = "nextGain";

    @Override
    public ZAWAModuleConfig.ModuleOption<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    public void entityConstructed(AbstractZawaLand entity) {
        super.entityConstructed(entity);
        entity.getAnimalInt().put(ENRICHMENT_COOLDOWN, 0);
        entity.getAnimalInt().put(SEARCH_COOLDOWN, 0);
        entity.getAnimalInt().put(SOCIAL_COUNT, 0);
        entity.getAnimalInt().put(NEXT_GAIN, 0);
    }

    @Override
    public void writeData(AbstractZawaLand entity, NBTTagCompound tag) {
        super.writeData(entity, tag);
        tag.func_74780_a("Enrichment", (double)this.getEnrichment(entity));
        tag.func_74780_a("ESaturation", (double)this.getEnrichmentSaturation(entity));
    }

    @Override
    public void readData(AbstractZawaLand entity, NBTTagCompound tag) {
        super.readData(entity, tag);
        this.setEnrichment(entity, tag.func_74760_g("Enrichment"));
        this.setEnrichmentSaturation(entity, tag.func_74760_g("ESaturation"));
    }

    @Override
    public void registerData(AbstractZawaLand entity) {
        super.registerData(entity);
        entity.func_184212_Q().func_187214_a(AbstractZawaLand.ENRICHMENT, (Object)Float.valueOf(this.getMaxEnrichment()));
        entity.func_184212_Q().func_187214_a(AbstractZawaLand.ESATURATION, (Object)Float.valueOf(0.0f));
    }

    public boolean lowEnrichment(AbstractZawaLand entity) {
        return entity.func_70909_n() && this.getEnrichment(entity) < this.getMaxEnrichment() - 0.3f;
    }

    @Override
    public void onUpdate(AbstractZawaLand entity) {
        super.onUpdate(entity);
        int value = entity.getAnimalInt().get(ENRICHMENT_COOLDOWN);
        if (value > 0) {
            entity.getAnimalInt().put(ENRICHMENT_COOLDOWN, value - 1);
        }
    }

    @Override
    public Boolean playerInteract(AbstractZawaLand entity, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.lowEnrichment(entity) && UsableHandler.USABLES.containsKey(stack.func_77973_b())) {
            UsableObject<?> i = UsableHandler.USABLES.get(stack.func_77973_b());
            if (i.shouldUse.apply(entity).booleanValue() && i.canUseStack.apply(entity, player).booleanValue()) {
                ZAWAEnrichEvent event = new ZAWAEnrichEvent(player, entity, i);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    return false;
                }
                this.onEnrich(entity, i);
                return true;
            }
        }
        return super.playerInteract(entity, player, hand);
    }

    @Override
    public void onLivingStatHandle(AbstractZawaLand entity) {
        super.onLivingStatHandle(entity);
        if (entity.func_70089_S()) {
            if (this.getEnrichmentSaturation(entity) <= 0.0f) {
                this.setEnrichment(entity, (float)((double)this.getEnrichment(entity) - ZAWAConfig.serverOptions.enrichmentDeprecation));
                this.setEnrichmentSaturation(entity, 0.0f);
            } else {
                this.setEnrichmentSaturation(entity, this.getEnrichmentSaturation(entity) - 0.0025f);
            }
        }
        if ((double)this.getEnrichment(entity) <= 3.0 && entity.field_70170_p.field_72995_K && entity.field_70173_aa % 15 == 0) {
            entity.playSickEffect();
        }
        if (this.getEnrichment(entity) <= this.lowEnrichmentDamageStart.getValue().floatValue()) {
            if (entity.field_70173_aa % 20 == 0) {
                entity.func_70097_a(ZAWAMain.depression, this.depressionDamage.getValue().floatValue());
            }
            this.setEnrichment(entity, 0.0f);
        }
    }

    public float getMaxEnrichment() {
        return this.maxEnrichment.getValue().floatValue();
    }

    public void setEnrichment(AbstractZawaLand entity, float e) {
        if (!this.entityHasModule(entity)) {
            return;
        }
        entity.func_184212_Q().func_187227_b(AbstractZawaLand.ENRICHMENT, (Object)Float.valueOf(e));
    }

    public float getEnrichment(AbstractZawaLand ent) {
        return this.entityHasModule(ent) ? ((Float)ent.func_184212_Q().func_187225_a(AbstractZawaLand.ENRICHMENT)).floatValue() : 0.0f;
    }

    public void setEnrichmentSaturation(AbstractZawaLand ent, float e) {
        if (!this.entityHasModule(ent)) {
            return;
        }
        ent.func_184212_Q().func_187227_b(AbstractZawaLand.ESATURATION, (Object)Float.valueOf(e));
    }

    public float getEnrichmentSaturation(AbstractZawaLand ent) {
        return this.entityHasModule(ent) ? ((Float)ent.func_184212_Q().func_187225_a(AbstractZawaLand.ESATURATION)).floatValue() : 0.0f;
    }

    @Override
    public void onTame(AbstractZawaLand entity, EntityPlayer player) {
        super.onTame(entity, player);
        this.setEnrichment(entity, this.getMaxEnrichment());
    }

    public boolean onEnrich(AbstractZawaLand ent, UsableObject<?> a) {
        if (!this.entityHasModule(ent)) {
            return false;
        }
        ZAWAEnrichEvent event = new ZAWAEnrichEvent(null, ent, a);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (ent.getAnimalInt().get(ENRICHMENT_COOLDOWN) > 0) {
            return false;
        }
        ent.getAnimalInt().put(ENRICHMENT_COOLDOWN, this.enrichmentCooldown.getValue());
        this.setEnrichment(ent, a.enrichmentAmount + this.getEnrichment(ent));
        this.setEnrichmentSaturation(ent, a.saturation + this.getEnrichmentSaturation(ent));
        if (this.getEnrichment(ent) > this.getMaxEnrichment()) {
            this.setEnrichment(ent, this.getMaxEnrichment());
        }
        if (a.enrichmentAmount > 0.0f) {
            ent.field_70170_p.func_72960_a((Entity)ent, (byte)31);
        }
        return true;
    }

    @Override
    public void postLivingStatHandle(AbstractZawaLand entity) {
        super.postLivingStatHandle(entity);
        float search = 10.0f;
        if (this.lowEnrichment(entity) && entity.func_70909_n() && entity.func_70638_az() == null) {
            List list = entity.field_70170_p.func_72872_a(Entity.class, entity.func_174813_aQ().func_186662_g((double)search + 5.0));
            double d0 = Double.MAX_VALUE;
            Object obj = null;
            for (Entity e : list) {
                if (!(entity.func_70068_e(e) < d0) || !UsableHandler.USABLES.containsKey(e.getClass())) continue;
                obj = e;
                d0 = entity.func_70068_e(e);
            }
            if (obj != null) {
                UsableObject<?> aa = UsableHandler.USABLES.get(obj.getClass());
                if (UsableHandler.USABLES.containsKey(obj.getClass()) && aa.shouldUse.apply(entity).booleanValue() && aa.canUseEntity.apply(entity, (Entity)obj).booleanValue() && obj instanceof EntityLivingBase) {
                    entity.func_70624_b((EntityLivingBase)obj);
                }
            }
        } else if (entity.func_70638_az() != null) {
            entity.func_70624_b(null);
        }
        if (entity.func_70909_n() && entity.getAnimalInt().get(NEXT_GAIN) > 0) {
            entity.getAnimalInt().put(NEXT_GAIN, entity.getAnimalInt().get(NEXT_GAIN) - 1);
        }
        if (entity.getAnimalInt().get(SOCIAL_COUNT) >= 200 && this.getEnrichment(entity) < this.getMaxEnrichment() - 1.0f && entity.func_70909_n()) {
            double distance = 6.0;
            Entity entityFound = null;
            double d4 = -1.0;
            for (int i = 0; i < entity.field_70170_p.field_72996_f.size(); ++i) {
                double d5;
                Entity currE = (Entity)entity.field_70170_p.field_72996_f.get(i);
                if (currE.getClass() != entity.getClass() || currE == entity || !((d5 = currE.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
                d4 = d5;
                entityFound = currE;
            }
            if (entityFound != null) {
                if (entity.field_70170_p.field_72995_K) {
                    entity.playEnrichmentEffect();
                }
                this.setEnrichment(entity, this.getEnrichment(entity) + 0.03f);
                entity.getAnimalInt().put(SOCIAL_COUNT, 0);
            }
        }
        if (entity.func_70909_n()) {
            entity.getAnimalInt().put(SOCIAL_COUNT, entity.getAnimalInt().get(SOCIAL_COUNT) + 1);
        }
    }
}

