/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.flying.EntityBaldEagle;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderBaldEagle
extends RenderLivingZAWA<EntityBaldEagle>
implements IBabyModel<EntityBaldEagle> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderBaldEagle(RenderManager m) {
        super(m, (ModelBase)RenderConstants.EAGLE, 0.3f);
        RenderConstants.EAGLE.setAnimator(EagleAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityBaldEagle entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 0);
    }

    @Override
    protected void preRenderCallback(EntityBaldEagle entity, float partialTickTime) {
        if (!entity.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.04f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.3f, (float)1.3f, (float)1.3f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.09f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        }
        GlStateManager.func_179114_b((float)entity.getPitchRotation(), (float)1.0f, (float)0.0f, (float)0.0f);
        super.preRenderCallback(entity, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityBaldEagle entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.EAGLE_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityBaldEagle e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/bald_eagle/bald_eagle.png");
        CONTAINER.addResource("textures/entity/bald_eagle/bald_eagle_2.png");
        CONTAINER.addResource("textures/entity/bald_eagle/bald_eagle_3.png");
        CONTAINER.addResource("baby", "textures/entity/bald_eagle/bald_eagle_baby.png");
        CONTAINER.addResource("blink", "textures/entity/bald_eagle/baldeagle_blink.png");
        CONTAINER.addResource("blink", "textures/entity/bald_eagle/baldeagle_blink_baby.png");
    }

    public static class EagleAnimator
    extends ZAWAAnimator<EntityBaldEagle> {
        private final BookwormModelRenderer WingBaseRight = this.getModel().getPartByName("Wing Base Right");
        private final BookwormModelRenderer WingBaseLeft = this.getModel().getPartByName("Wing Base Left");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("Neck");

        public EagleAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityBaldEagle entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.neck.field_78795_f = f4 / 57.295776f - 0.4f;
            this.neck.field_78808_h = f3 / 57.295776f;
            if (!entity.field_70122_E && !(entity.func_184187_bx() instanceof EntityPlayer)) {
                this.neck.field_78795_f = f4 / 57.295776f - 0.4f;
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.EAGLE_FLYING);
                f = entity.field_70173_aa;
                f1 = 0.2f;
                this.speed = 1.0f;
                this.speed = ZAWAUtils.movingUp((Entity)entity) ? 2.0f : (ZAWAUtils.movingDown((Entity)entity) ? 0.4f : 0.1f);
                this.WingBaseLeft.field_78796_g = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 1.5f - 1.6f;
                this.WingBaseRight.field_78796_g = MathHelper.func_76134_b((float)(f * (0.3662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 1.5f - 1.6f;
            }
        }
    }
}

