/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityAsianElephant;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderAsianElephant
extends RenderLivingZAWA<EntityAsianElephant>
implements IBabyModel<EntityAsianElephant> {
    public static final ResourceLocation saddle = new ResourceLocation("zawa:textures/entity/asian_elephant/asian_elephant_saddle.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAsianElephant(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.ASIAN_ELEPHANT, 1.2f);
        this.func_177094_a(new LayerSaddleElephant(this));
        RenderConstants.ASIAN_ELEPHANT_BABY.setAnimator(ElephantAnimator::new);
        RenderConstants.ASIAN_ELEPHANT.setAnimator(ElephantAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityAsianElephant elepnt, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.2f);
        if (elepnt.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            if (elepnt.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
            }
        } else {
            if (ModuleManager.GENDER.getGender(elepnt) == Gender.FEMALE) {
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.4f);
        }
        super.preRenderCallback(elepnt, partialTickTime);
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAsianElephant entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityAsianElephant animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityAsianElephant e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.ASIAN_ELEPHANT_BABY.setAnimator(ElephantAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAsianElephant e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/asian_elephant/asian_elephant.png");
        CONTAINER.addResource("textures/entity/asian_elephant/asian_elephant_2.png");
        CONTAINER.addResource("textures/entity/asian_elephant/asian_elephant_3.png");
        CONTAINER.addResource("textures/entity/asian_elephant/asian_elephant_4.png");
        CONTAINER.addResource("textures/entity/asian_elephant/asian_elephant_5.png");
        CONTAINER.addResource("baby", "textures/entity/asian_elephant/asian_elephant_baby.png");
        CONTAINER.addResource("blink", "textures/entity/asian_elephant/asian_elephant_blink.png");
        CONTAINER.addResource("blink", "textures/entity/asian_elephant/asianelephantbaby_blink.png");
    }

    public static class ElephantAnimator
    extends ZAWAAnimator<EntityAsianElephant> {
        private final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("Thigh Right");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("Thigh Left");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("Arm Left");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("Arm Right");
        private final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer ear1 = this.getModel().getPartFromRig("Ear Right");
        private final BookwormModelRenderer ear2 = this.getModel().getPartFromRig("Ear Left");
        private final BookwormModelRenderer trunkBase = this.getModel().getPartFromRig("Trunk Base");
        private final BookwormModelRenderer trunk = this.getModel().getPartFromRig("Trunk");
        private final BookwormModelRenderer trunk2 = this.getModel().getPartFromRig("Trunk 2");
        private final BookwormModelRenderer trunk3 = this.getModel().getPartFromRig("Trunk 3");
        private final BookwormModelRenderer trunkTip = this.getModel().getPartFromRig("Trunk Tip");
        private final BookwormModelRenderer Tail = this.getModel().getPartFromRig("Tail");
        private final BookwormModelRenderer TuskA = this.getModel().getPartFromRig("Tusk Base Left");
        private final BookwormModelRenderer TuskB = this.getModel().getPartFromRig("Tusk Base Right");
        private final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        private final BookwormModelRenderer FootBRight = this.getModel().getPartFromRig("Foot B Right");
        private final BookwormModelRenderer FootBLeft = this.getModel().getPartFromRig("Foot B Left");
        private final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("Leg Right");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("Leg Left");
        private final BookwormModelRenderer ForearmRight = this.getModel().getPartFromRig("Forearm Right");
        private final BookwormModelRenderer ForearmLeft = this.getModel().getPartFromRig("Forearm Left");
        private final BookwormModelRenderer FootFRight = this.getModel().getPartFromRig("Foot F Right");
        private final BookwormModelRenderer FootFLeft = this.getModel().getPartFromRig("Foot F Left");
        private final BookwormModelRenderer Hips = this.getModel().getPartFromRig("Hips");

        public ElephantAnimator(ModelCMF model) {
            super(model);
        }

        public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        @Override
        public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, EntityAsianElephant e) {
            if (e instanceof EntityAsianElephant) {
                if (ModuleManager.GENDER.getGender(e) == Gender.FEMALE) {
                    this.TuskA.renderPartScale = 0.0f;
                    this.TuskB.renderPartScale = 0.0f;
                } else {
                    this.TuskA.renderPartScale = 1.0f;
                    this.TuskB.renderPartScale = 1.0f;
                }
            }
            super.setRotationAngles(f, f1, f2, f3, f4, f5, e);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAsianElephant e) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 2.8f;
            this.degree = 0.5f;
            EntityAsianElephant elephant = e;
            if (e.func_184179_bs() == null) {
                this.trunkBase.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f - 0.5f;
                this.trunk.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f;
                this.trunk3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f;
            } else {
                this.setRotateAngle((ModelRenderer)this.trunkBase, -0.5235988f, 0.0f, 0.0f);
                this.setRotateAngle((ModelRenderer)this.trunk, -0.3642502f, -0.0f, 0.0f);
                this.setRotateAngle((ModelRenderer)this.trunk3, -1.1383038f, 0.0f, 0.0f);
            }
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(10.0f + f * this.speed * 0.5f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -2.1f) * f1 * 0.5f + 0.14f;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(21.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.2f;
            this.FootBRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + -0.2f;
            this.ThighRight.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(46.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + -0.1f;
            this.ForearmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.1f) * f1 * 0.5f + 0.1f;
            this.FootFRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + -0.1f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f + 0.14f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(21.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.8f) * f1 * 0.5f + 0.2f;
            this.FootBLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + -0.2f;
            this.ThighLeft.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f;
            this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(46.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + -0.1f;
            this.ForearmLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * -1.1f) * f1 * 0.5f + 0.1f;
            this.FootFLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + -0.1f;
            this.Hips.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.4f + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f + -0.25f;
            this.Tail.field_78808_h = MathHelper.func_76134_b((float)(-0.3f + f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f;
            this.ear1.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f - 0.5f;
            this.ear2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f + 0.5f;
            this.neck.field_78795_f = f4 / 57.295776f - 0.2f;
            this.neck.field_78796_g = f3 / 57.295776f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.3f - 0.2f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAsianElephant e) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 0.2f;
            this.degree = 1.1f;
            this.trunkBase.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 0.5f;
            this.trunk2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f;
            this.trunk3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1862f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f;
            this.Tail.field_78808_h = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f * -1.0f) * f1 * 0.5f;
            this.ear2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f + 0.1f;
            this.ear1.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f - 0.1f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(32.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.7f) * f1 * 0.3f - 0.2f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerSaddleElephant
    implements LayerRenderer<EntityAsianElephant> {
        private final RenderAsianElephant render;

        public LayerSaddleElephant(RenderAsianElephant re) {
            this.render = re;
        }

        public void doRenderLayer(EntityAsianElephant elephant, float p_177155_2_, float p_177155_3_, float p_177155_4_, float p_177155_5_, float p_177155_6_, float p_177155_7_, float p_177155_8_) {
            if (!elephant.func_82150_aj() && ModuleManager.SADDLE.isSaddled(elephant)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
                this.render.func_110776_a(saddle);
                RenderConstants.ASIAN_ELEPHANT.func_178686_a(this.render.func_177087_b());
                RenderConstants.ASIAN_ELEPHANT.func_78087_a(p_177155_2_, p_177155_3_, p_177155_5_, p_177155_6_, p_177155_7_, p_177155_8_, (Entity)elephant);
                RenderConstants.ASIAN_ELEPHANT.func_78088_a((Entity)elephant, p_177155_2_, p_177155_3_, p_177155_5_, p_177155_6_, p_177155_7_, p_177155_8_);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

