/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.world.caps.world;

import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.UpdateWorldMusicData;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.MXTuneException;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.world.caps.world.IModWorldPlaylist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class ModWorldPlaylistHelper {
    @CapabilityInject(value=IModWorldPlaylist.class)
    public static final Capability<IModWorldPlaylist> MOD_WORLD_DATA = (Capability)Miscellus.nonNullInjected();

    private ModWorldPlaylistHelper() {
    }

    public static void setPlaylistGuid(World world, GUID guid) {
        try {
            ModWorldPlaylistHelper.getImpl(world).setPlaylistGuid(guid);
        }
        catch (MXTuneException e) {
            ModLogger.error(e);
        }
    }

    public static GUID getPlaylistGuid(World world) {
        try {
            return ModWorldPlaylistHelper.getImpl(world).getPlaylistGuid();
        }
        catch (MXTuneException e) {
            ModLogger.error(e);
            return Reference.EMPTY_GUID;
        }
    }

    private static IModWorldPlaylist getImpl(World world) throws MXTuneException {
        if (!world.hasCapability(MOD_WORLD_DATA, null)) {
            throw new MXTuneException("IModWorldData capability is null");
        }
        IModWorldPlaylist worldData = (IModWorldPlaylist)world.getCapability(MOD_WORLD_DATA, null);
        return worldData;
    }

    public static void sync(EntityPlayer entityPlayer, World world) {
        PacketDispatcher.sendToDimension(new UpdateWorldMusicData(ModWorldPlaylistHelper.getPlaylistGuid(world)), entityPlayer.func_130014_f_().field_73011_w.getDimension());
    }
}

