/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.world.caps.world;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.NBTHelper;
import net.aeronica.mods.mxtune.world.caps.world.IModWorldPlaylist;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistImpl;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModWorldPlaylistCap {
    @CapabilityInject(value=IModWorldPlaylist.class)
    private static final Capability<IModWorldPlaylist> MOD_WORLD_DATA = (Capability)Miscellus.nonNullInjected();

    private ModWorldPlaylistCap() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IModWorldPlaylist.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
        MinecraftForge.EVENT_BUS.register(ModWorldPlaylistCap.class);
    }

    @SubscribeEvent
    public static void onEvent(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() != null) {
            event.addCapability(new ResourceLocation("mxtune", "world_music"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IModWorldPlaylist instance = (IModWorldPlaylist)ModWorldPlaylistCap.access$200().getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == MOD_WORLD_DATA;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == MOD_WORLD_DATA ? MOD_WORLD_DATA.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)MOD_WORLD_DATA.getStorage().writeNBT(MOD_WORLD_DATA, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    MOD_WORLD_DATA.getStorage().readNBT(MOD_WORLD_DATA, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    private static class Storage
    implements Capability.IStorage<IModWorldPlaylist> {
        private Storage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<IModWorldPlaylist> capability, IModWorldPlaylist instance, EnumFacing side) {
            NBTTagCompound properties = new NBTTagCompound();
            NBTHelper.setGuidToCompound(properties, instance.getPlaylistGuid());
            return properties;
        }

        public void readNBT(Capability<IModWorldPlaylist> capability, IModWorldPlaylist instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound properties = (NBTTagCompound)nbt;
            instance.setPlaylistGuid(NBTHelper.getGuidFromCompound(properties));
        }
    }

    private static class Factory
    implements Callable<IModWorldPlaylist> {
        private Factory() {
        }

        @Override
        public IModWorldPlaylist call() {
            return new ModWorldPlaylistImpl();
        }
    }
}

