/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.world;

import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.NBTTagCompound;

@Immutable
public class OwnerUUID {
    public static final OwnerUUID EMPTY_UUID = new OwnerUUID(0L, 0L);
    private static final String OWNER_UUID_KEY_MSB = "OwnerUUIDKeyMSB";
    private static final String OWNER_UUID_KEY_LSB = "OwnerUUIDKeyLSB";
    private final UUID uuid;

    public OwnerUUID(UUID uuid) {
        this.uuid = uuid;
    }

    private OwnerUUID(long msb, long lsb) {
        this.uuid = new UUID(msb, lsb);
    }

    public boolean isEmpty() {
        return this.uuid == null || OwnerUUID.EMPTY_UUID.uuid.equals(this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void toNBT(NBTTagCompound nbt) {
        nbt.func_74772_a(OWNER_UUID_KEY_MSB, this.uuid.getMostSignificantBits());
        nbt.func_74772_a(OWNER_UUID_KEY_LSB, this.uuid.getLeastSignificantBits());
    }

    public static OwnerUUID fromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b(OWNER_UUID_KEY_MSB, 4) && nbt.func_150297_b(OWNER_UUID_KEY_LSB, 4)) {
            long msb = nbt.func_74763_f(OWNER_UUID_KEY_MSB);
            long lsb = nbt.func_74763_f(OWNER_UUID_KEY_LSB);
            return new OwnerUUID(msb, lsb);
        }
        return EMPTY_UUID;
    }

    public String toString() {
        return this.uuid.toString();
    }

    public int hashCode() {
        long highLow = this.uuid.getMostSignificantBits() ^ this.uuid.getLeastSignificantBits();
        return (int)(highLow >> 32) ^ (int)highLow;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != OwnerUUID.class) {
            return false;
        }
        UUID id = ((OwnerUUID)obj).getUUID();
        return this.uuid.getMostSignificantBits() == id.getMostSignificantBits() && this.uuid.getLeastSignificantBits() == id.getLeastSignificantBits();
    }
}

