/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.world;

import net.aeronica.mods.mxtune.world.IModLockableContainer;
import net.aeronica.mods.mxtune.world.OwnerUUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LockableHelper {
    private LockableHelper() {
    }

    public static boolean isLocked(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        return LockableHelper.isLocked(playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static boolean isLocked(EntityPlayer playerIn, World worldIn, int x, int y, int z) {
        TileEntity tileEntity = worldIn.func_175625_s(new BlockPos(x, y, z));
        boolean isLocked = false;
        if (tileEntity instanceof IModLockableContainer) {
            IModLockableContainer lockableContainer = (IModLockableContainer)tileEntity;
            isLocked = LockableHelper.canOpen(playerIn, lockableContainer);
        }
        return isLocked;
    }

    public static boolean canLock(EntityPlayer playerIn, IModLockableContainer lockableContainer) {
        OwnerUUID ownerUUID = new OwnerUUID(playerIn.getPersistentID());
        return lockableContainer.isOwner(ownerUUID) && !playerIn.func_175149_v();
    }

    private static boolean canOpen(EntityPlayer playerIn, IModLockableContainer lockableContainer) {
        OwnerUUID ownerUUID = new OwnerUUID(playerIn.getPersistentID());
        return lockableContainer.isLocked() && !lockableContainer.isOwner(ownerUUID) && !playerIn.func_175149_v();
    }

    public static boolean isBreakable(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        return LockableHelper.isBreakable(playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static boolean isBreakable(EntityPlayer playerIn, World worldIn, int x, int y, int z) {
        TileEntity tileEntity = worldIn.func_175625_s(new BlockPos(x, y, z));
        boolean isBreakable = false;
        if (tileEntity instanceof IModLockableContainer) {
            IModLockableContainer lockableContainer = (IModLockableContainer)tileEntity;
            isBreakable = LockableHelper.canBreak(playerIn, lockableContainer);
        }
        return isBreakable;
    }

    private static boolean canBreak(EntityPlayer playerIn, IModLockableContainer lockableContainer) {
        OwnerUUID ownerUUID = new OwnerUUID(playerIn.getPersistentID());
        return !lockableContainer.isOwner(ownerUUID) && !playerIn.func_175149_v();
    }
}

