/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.util;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;

public enum EnumRelativeSide {
    BACK(0, "back"),
    RIGHT(1, "right"),
    FRONT(2, "front"),
    LEFT(3, "left"),
    TOP(4, "top"),
    BOTTOM(5, "bottom"),
    ERROR(6, "error");

    int index;
    String name;
    private static final EnumRelativeSide[] ENUM_RELATIVE_SIDES;

    private EnumRelativeSide(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static EnumRelativeSide getRelativeSide(@Nullable EnumFacing side, @Nullable EnumFacing facing) {
        EnumRelativeSide enumRelativeSide;
        if (side == null || facing == null) {
            enumRelativeSide = ERROR;
        } else if (side == EnumFacing.UP) {
            enumRelativeSide = TOP;
        } else if (side == EnumFacing.DOWN) {
            enumRelativeSide = BOTTOM;
        } else {
            int index = facing.func_176736_b() * 4 + side.func_176736_b();
            enumRelativeSide = ENUM_RELATIVE_SIDES[Math.abs(index % ENUM_RELATIVE_SIDES.length)];
        }
        return enumRelativeSide;
    }

    static {
        ENUM_RELATIVE_SIDES = new EnumRelativeSide[]{FRONT, LEFT, BACK, RIGHT, RIGHT, FRONT, LEFT, BACK, BACK, RIGHT, FRONT, LEFT, LEFT, BACK, RIGHT, FRONT};
    }
}

