/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.status;

import java.io.Serializable;

public class ClientStateData
implements Serializable {
    private static final long serialVersionUID = 7855748956912934732L;
    private final boolean midiAvailable;
    private final boolean masterVolumeOn;
    private final boolean mxtuneVolumeOn;

    public ClientStateData() {
        this.midiAvailable = false;
        this.masterVolumeOn = false;
        this.mxtuneVolumeOn = false;
    }

    public ClientStateData(boolean midiAvailable, boolean masterVolumeOn, boolean mxtuneVolumeOn) {
        this.midiAvailable = midiAvailable;
        this.masterVolumeOn = masterVolumeOn;
        this.mxtuneVolumeOn = mxtuneVolumeOn;
    }

    public boolean isMidiAvailable() {
        return this.midiAvailable;
    }

    public boolean isMasterVolumeOn() {
        return this.masterVolumeOn;
    }

    public boolean isMxtuneVolumeOn() {
        return this.mxtuneVolumeOn;
    }

    boolean isEqual(ClientStateData csd) {
        return csd != null && this.midiAvailable == csd.midiAvailable && this.masterVolumeOn == csd.masterVolumeOn && this.mxtuneVolumeOn == csd.mxtuneVolumeOn;
    }

    public boolean isGood() {
        return this.midiAvailable && this.masterVolumeOn && this.mxtuneVolumeOn;
    }

    public String toString() {
        return "{midiAvailable=" + this.midiAvailable + ", isMasterVolumeOn=" + this.masterVolumeOn + ", mxtuneVolumeOn=" + this.mxtuneVolumeOn + "}";
    }
}

