/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum SoundRange {
    NORMAL(2.0f, "mxtune.sound_range.normal", true),
    INFINITY(1.0f, "mxtune.sound_range.infinity", false);

    public static final int LENGTH;
    public static final String SOUND_RANGE_KEY = "soundRange";
    float range;
    String languageKey;
    boolean useLinear;

    private SoundRange(float rangeIn, String languageKeyIn, boolean useLinearIn) {
        this.range = rangeIn;
        this.languageKey = languageKeyIn;
        this.useLinear = useLinearIn;
    }

    public float getRange() {
        return this.range;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound.AttenuationType getAttenuationType() {
        return this.useLinear ? ISound.AttenuationType.LINEAR : ISound.AttenuationType.NONE;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public static SoundRange nextRange(SoundRange soundRange) {
        return SoundRange.getSoundRange(soundRange.ordinal() + 1);
    }

    public static int getIndex(SoundRange soundRange) {
        return soundRange.ordinal();
    }

    public static SoundRange getSoundRange(SoundRange soundRange) {
        return SoundRange.values()[soundRange.ordinal()];
    }

    public static SoundRange getSoundRange(int index) {
        return SoundRange.values()[index % LENGTH];
    }

    public void toNBT(NBTTagCompound nbt) {
        nbt.func_74778_a(SOUND_RANGE_KEY, this.name());
    }

    public static SoundRange fromNBT(NBTTagCompound nbt) {
        SoundRange soundRange = NORMAL;
        if (nbt.func_150297_b(SOUND_RANGE_KEY, 8)) {
            String s = nbt.func_74779_i(SOUND_RANGE_KEY);
            soundRange = SoundRange.safeSetFromString(s);
        }
        return soundRange;
    }

    private static SoundRange safeSetFromString(String name) {
        for (SoundRange soundRange : SoundRange.values()) {
            if (!name.contentEquals(soundRange.name())) continue;
            return SoundRange.valueOf(name);
        }
        return NORMAL;
    }

    static {
        LENGTH = SoundRange.values().length;
    }
}

