/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import com.sun.media.sound.AudioSynthesizer;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.aeronica.mods.mxtune.sound.ModMidiException;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;

public class Midi2WavRenderer
implements Receiver {
    AudioInputStream createPCMStream(Sequence sequence, AudioFormat format) throws ModMidiException, MidiUnavailableException {
        Soundbank mxTuneSoundBank = MIDISystemUtil.getMXTuneSoundBank();
        AudioSynthesizer audioSynthesizer = this.findAudioSynthesizer();
        if (audioSynthesizer == null) {
            throw new ModMidiException("No AudioSynthesizer was found!");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("interpolation", "sinc");
        p.put("max polyphony", "1024");
        AudioInputStream outputStream = audioSynthesizer.openStream(format, p);
        Soundbank defaultSoundbank = audioSynthesizer.getDefaultSoundbank();
        if (defaultSoundbank != null) {
            audioSynthesizer.unloadAllInstruments(defaultSoundbank);
        }
        audioSynthesizer.loadAllInstruments(mxTuneSoundBank);
        Receiver receiver = audioSynthesizer.getReceiver();
        double total = this.send(sequence, receiver);
        long len = (long)((double)outputStream.getFormat().getFrameRate() * (total + 4.0));
        outputStream = new AudioInputStream(outputStream, outputStream.getFormat(), len);
        receiver.close();
        return outputStream;
    }

    @Nullable
    private AudioSynthesizer findAudioSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info[] midiDeviceInfo;
        Synthesizer synth = MidiSystem.getSynthesizer();
        if (synth instanceof AudioSynthesizer) {
            return (AudioSynthesizer)synth;
        }
        for (MidiDevice.Info aMidiDeviceInfo : midiDeviceInfo = MidiSystem.getMidiDeviceInfo()) {
            MidiDevice dev = MidiSystem.getMidiDevice(aMidiDeviceInfo);
            if (!(dev instanceof AudioSynthesizer)) continue;
            return (AudioSynthesizer)dev;
        }
        return null;
    }

    public double getSequenceInSeconds(Sequence sequence) throws ModMidiException {
        return this.send(sequence, this);
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
    }

    @Override
    public void close() {
    }

    private double send(@Nullable Sequence seq, @Nullable Receiver receiver) throws ModMidiException {
        if (seq == null) {
            return 0.0;
        }
        float divisionType = seq.getDivisionType();
        Track[] tracks = seq.getTracks();
        int[] tracksPos = new int[tracks.length];
        int mpq = 500000;
        int seqResolution = seq.getResolution();
        long lastTick = 0L;
        long currentTime = 0L;
        while (true) {
            MidiEvent selectedEvent = null;
            int selectedTrack = -1;
            for (int i = 0; i < tracks.length; ++i) {
                int trackPos = tracksPos[i];
                Track track = tracks[i];
                if (trackPos >= track.size()) continue;
                MidiEvent event = track.get(trackPos);
                if (selectedEvent != null && event.getTick() >= selectedEvent.getTick()) continue;
                selectedEvent = event;
                selectedTrack = i;
            }
            if (selectedTrack == -1) break;
            int n = selectedTrack;
            tracksPos[n] = tracksPos[n] + 1;
            if (selectedEvent == null) {
                throw new ModMidiException("Null MidiEvent in 'send' method: " + seq);
            }
            long tick = selectedEvent.getTick();
            currentTime = (int)divisionType == 0 ? (currentTime += (tick - lastTick) * (long)mpq / (long)seqResolution) : (long)((double)tick * 1000000.0 * (double)divisionType / (double)seqResolution);
            lastTick = tick;
            MidiMessage msg = selectedEvent.getMessage();
            if (msg instanceof MetaMessage) {
                if ((int)divisionType != 0 || ((MetaMessage)msg).getType() != 81) continue;
                byte[] data = ((MetaMessage)msg).getData();
                mpq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                continue;
            }
            if (receiver == null) continue;
            receiver.send(msg, currentTime);
        }
        return (double)currentTime / 1000000.0;
    }
}

