/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import net.aeronica.libs.mml.midi.MIDIHelper;
import net.aeronica.libs.mml.parser.MMLObject;
import net.aeronica.libs.mml.parser.MMLUtil;
import net.aeronica.mods.mxtune.util.MapListHelper;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MMLToMIDI {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int OFFSET = 10;
    private static final TicksOffset TICKS_OFFSET = new TicksOffset(10L);
    private Sequence sequence;
    private final Set<Integer> presets = new HashSet<Integer>();
    private int channel;
    private int track;
    private String currentTransform = "";
    private Map<Integer, Integer> noteTranslations = new HashMap<Integer, Integer>();

    public Sequence getSequence() {
        return this.sequence;
    }

    public List<Integer> getPresets() {
        return new ArrayList<Integer>(this.presets);
    }

    public void processMObjects(List<MMLObject> mmlObjects) {
        this.channel = 0;
        this.track = 1;
        try {
            this.sequence = new Sequence(0.0f, 480);
            for (int i = 0; i < 160; ++i) {
                this.sequence.createTrack();
            }
            Track[] tracks = this.sequence.getTracks();
            block12: for (MMLObject mmo : mmlObjects) {
                switch (mmo.getType()) {
                    case INIT: 
                    case REST: 
                    case DONE: {
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                    case SUSTAIN: {
                        this.setSustain(mmo, tracks, this.track, this.channel);
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                    case TEMPO: {
                        this.setTempo(mmo, tracks);
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                    case INST: {
                        this.addInstrument(mmo, tracks, this.track, this.channel);
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                    case PART: {
                        this.nextTrack();
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                    case NOTE: {
                        this.addNote(mmo, tracks, this.track, this.channel);
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                    case STOP: {
                        this.nextTrack();
                        this.nextChannel();
                        this.addText(mmo, tracks, this.track, this.channel);
                        continue block12;
                    }
                }
                LOGGER.debug("MMLToMIDI#processMObjects Impossible?! An undefined enum?");
            }
        }
        catch (InvalidMidiDataException e) {
            LOGGER.error((Object)e);
        }
    }

    private void nextTrack() {
        if (this.track++ > 160) {
            this.track = 160;
        }
    }

    private void nextChannel() {
        ++this.channel;
        if (this.channel == 8) {
            this.channel = 10;
        }
        if (this.channel > 15) {
            this.channel = 15;
        }
    }

    private void addInstrument(MMLObject mmo, Track[] tracks, int track, int ch) throws InvalidMidiDataException {
        Patch preset = MMLUtil.packedPreset2Patch(SoundFontProxyManager.getPackedPreset(mmo.getInstrument()));
        this.updateCurrentSoundFontProxy(mmo.getInstrument());
        int bank = preset.getBank();
        int programPreset = preset.getProgram();
        bank = bank == 128 ? 15360 : (bank <<= 7);
        long startingTicks = TICKS_OFFSET.apply(mmo.getStartingTicks());
        tracks[track].add(MIDIHelper.createBankSelectEventMSB(ch, bank, startingTicks - 2L));
        tracks[track].add(MIDIHelper.createBankSelectEventLSB(ch, bank, startingTicks - 1L));
        tracks[track].add(MIDIHelper.createProgramChangeEvent(ch, programPreset, startingTicks));
        this.presets.add(mmo.getInstrument());
    }

    private void updateCurrentSoundFontProxy(int preset) {
        if (SoundFontProxyManager.hasTransform(preset)) {
            this.currentTransform = SoundFontProxyManager.getTransform(preset);
            this.noteTranslations.clear();
            this.noteTranslations = MapListHelper.deserializeIntIntMap(this.currentTransform);
            ModLogger.debug("Transform: %s", this.noteTranslations.entrySet());
        } else {
            this.currentTransform = "";
            this.noteTranslations.clear();
        }
    }

    private int transformNote(int midiNote) {
        if (!this.currentTransform.isEmpty()) {
            return this.noteTranslations.getOrDefault(midiNote, midiNote);
        }
        return midiNote;
    }

    private void addNote(MMLObject mmo, Track[] tracks, int track, int channel) throws InvalidMidiDataException {
        int midiNote = this.transformNote(mmo.getMidiNote());
        if (mmo.doNoteOn()) {
            tracks[track].add(MIDIHelper.createNoteOnEvent(channel, MMLUtil.smartClampMIDI(midiNote), mmo.getNoteVolume(), TICKS_OFFSET.apply(mmo.getStartingTicks())));
        }
        if (mmo.doNoteOff()) {
            tracks[track].add(MIDIHelper.createNoteOffEvent(channel, MMLUtil.smartClampMIDI(midiNote), mmo.getNoteVolume(), TICKS_OFFSET.apply(mmo.getStartingTicks(), mmo.getLengthTicks(), -1L)));
        }
    }

    private void addText(MMLObject mmo, Track[] tracks, int track, int channel) throws InvalidMidiDataException {
        String onOff = String.format("%s%s", mmo.doNoteOn() ? "^" : "-", mmo.doNoteOff() ? "v" : "-");
        String pitch = mmo.getType() == MMLObject.Type.NOTE ? String.format("%s(%03d)", onOff, mmo.getMidiNote()) : "--(---)";
        String text = String.format("{t=% 8d l=% 8d}[T:%02d C:%02d %s %s]{ %s }", mmo.getStartingTicks(), mmo.getLengthTicks(), track, channel, mmo.getType().name(), pitch, mmo.getText());
        tracks[0].add(MIDIHelper.createTextMetaEvent(text, TICKS_OFFSET.apply(mmo.getStartingTicks())));
    }

    private void setTempo(MMLObject mmo, Track[] tracks) throws InvalidMidiDataException {
        tracks[0].add(MIDIHelper.createTempoMetaEvent(mmo.getTempo(), TICKS_OFFSET.apply(mmo.getStartingTicks())));
    }

    private void setSustain(MMLObject mmo, Track[] tracks, int track, int channel) throws InvalidMidiDataException {
        int sustain = mmo.doSustain() ? 127 : 0;
        tracks[track].add(MIDIHelper.createControlChangeEvent(channel, 64, sustain, TICKS_OFFSET.apply(mmo.getStartingTicks())));
    }

    private static class TicksOffset {
        private final long offset;

        public TicksOffset(long offset) {
            this.offset = offset;
        }

        long apply(Long ... ticks) {
            AtomicReference<Long> value = new AtomicReference<Long>(0L);
            Arrays.asList(ticks).forEach(p -> {
                Long cfr_ignored_0 = (Long)value.updateAndGet(v -> v + p);
            });
            return value.get() + this.offset;
        }
    }
}

