/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.sound.IAudioStatusCallback;
import net.aeronica.mods.mxtune.sound.SoundRange;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.math.BlockPos;

public class AudioData {
    private final int playId;
    private final BlockPos blockPos;
    private final boolean isClientPlayer;
    private final SoundRange soundRange;
    private AudioInputStream audioStream;
    private AudioFormat audioFormat;
    private String uuid;
    private ISound iSound;
    private ClientAudio.Status status;
    private final PlayIdSupplier.PlayType playType;
    private final IAudioStatusCallback callback;
    private float volumeFade = 1.0f;
    private boolean isFading;
    private int fadeTicks;
    private int fadeCounter;

    AudioData(int playId, @Nullable BlockPos blockPos, boolean isClientPlayer, SoundRange soundRange, @Nullable IAudioStatusCallback callback) {
        this.playId = playId;
        this.playType = PlayIdSupplier.getTypeForPlayId(playId);
        this.blockPos = blockPos;
        this.isClientPlayer = isClientPlayer;
        this.soundRange = soundRange;
        this.status = ClientAudio.Status.WAITING;
        this.callback = callback;
        this.uuid = "";
    }

    public synchronized AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioFormat(AudioFormat audioFormat) {
        AudioData audioData = this;
        synchronized (audioData) {
            this.audioFormat = audioFormat;
        }
    }

    public synchronized ClientAudio.Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(ClientAudio.Status status) {
        AudioData audioData = this;
        synchronized (audioData) {
            if (this.status != status) {
                this.status = status;
                if (this.callback != null) {
                    this.callback.statusCallBack(this.status, this.playId);
                }
            }
        }
    }

    public int getPlayId() {
        return this.playId;
    }

    BlockPos getBlockPos() {
        return this.blockPos;
    }

    boolean isClientPlayer() {
        return this.isClientPlayer;
    }

    SoundRange getSoundRange() {
        return this.soundRange;
    }

    synchronized AudioInputStream getAudioStream() {
        return this.audioStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAudioStream(AudioInputStream audioStream) {
        AudioData audioData = this;
        synchronized (audioData) {
            this.audioStream = audioStream;
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    synchronized ISound getISound() {
        return this.iSound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setISound(ISound iSound) {
        AudioData audioData = this;
        synchronized (audioData) {
            this.iSound = iSound;
        }
    }

    public PlayIdSupplier.PlayType getPlayType() {
        return this.playType;
    }

    public void updateVolumeFade() {
        if (this.isFading) {
            --this.fadeCounter;
            if (this.fadeCounter > 0) {
                this.volumeFade = (float)this.fadeCounter / (float)this.fadeTicks;
            } else {
                this.isFading = false;
                this.volumeFade = 0.0f;
            }
        }
    }

    public void startFadeOut(int seconds) {
        if (!this.isFading && this.status != ClientAudio.Status.ERROR && this.status != ClientAudio.Status.DONE) {
            this.fadeCounter = this.fadeTicks = Math.max(Math.abs(seconds * 20), 1);
            this.volumeFade = 1.0f;
            this.isFading = true;
        }
    }

    public float getFadeMultiplier() {
        return this.volumeFade;
    }

    public boolean isFading() {
        return this.isFading;
    }
}

