/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.options;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.SyncPlayerMusicOptionsMessage;
import net.aeronica.mods.mxtune.network.server.ChunkToolMessage;
import net.aeronica.mods.mxtune.options.ClassifiedPlayer;
import net.aeronica.mods.mxtune.options.IPlayerMusicOptions;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.MXTuneRuntimeException;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class MusicOptionsUtil {
    public static final int SYNC_ALL = 0;
    public static final int SYNC_DISPLAY_HUD = 1;
    public static final int SYNC_MUTE_OPTION = 2;
    public static final int SYNC_S_PARAMS = 3;
    public static final int SYNC_WHITE_LIST = 4;
    public static final int SYNC_BLACK_LIST = 5;
    public static final int SYNC_MUSIC_OP = 6;
    public static final int SYNC_SELECTED_PLAY_LIST_GUID = 7;
    public static final int SYNC_CTRL_KEY_DOWN = 8;
    public static final int SYNC_CHUNK_OPERATION = 9;
    @CapabilityInject(value=IPlayerMusicOptions.class)
    private static final Capability<IPlayerMusicOptions> MUSIC_OPTIONS = (Capability)Miscellus.nonNullInjected();
    private static int adjustPositionHud = 0;
    private static float adjustSizeHud = 1.0f;

    private MusicOptionsUtil() {
    }

    public static void setHudOptions(EntityPlayer playerIn, boolean disableHud, int positionHud, float sizeHud) {
        MusicOptionsUtil.getImpl(playerIn).setHudOptions(disableHud, positionHud, sizeHud);
        MusicOptionsUtil.sync(playerIn, 1);
    }

    public static boolean isHudDisabled(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).isHudDisabled();
    }

    public static int getPositionHUD(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getPositionHud();
    }

    public static float getSizeHud(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getSizeHud();
    }

    public static boolean isMuteAll(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getMuteOption() == EnumMuteOptions.ALL.getIndex();
    }

    public static void setMuteOption(EntityPlayer playerIn, int muteOptionIn) {
        MusicOptionsUtil.getImpl(playerIn).setMuteOption(muteOptionIn);
        MusicOptionsUtil.sync(playerIn, 2);
    }

    private static EnumMuteOptions getMuteOptionEnum(EntityPlayer playerIn) {
        return EnumMuteOptions.byIndex(MusicOptionsUtil.getImpl(playerIn).getMuteOption());
    }

    public static int getMuteOption(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getMuteOption();
    }

    public static void setSParams(EntityPlayer playerIn, String sParam1, String sParam2, String sParam3) {
        MusicOptionsUtil.getImpl(playerIn).setSParams(sParam1, sParam2, sParam3);
        MusicOptionsUtil.sync(playerIn, 3);
    }

    public static String getSParam1(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getSParam1();
    }

    public static String getSParam2(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getSParam2();
    }

    public static String getSParam3(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getSParam3();
    }

    public static void setBlackList(EntityPlayer playerIn, List<ClassifiedPlayer> blackList) {
        MusicOptionsUtil.getImpl(playerIn).setBlackList(blackList);
        MusicOptionsUtil.sync(playerIn, 5);
    }

    public static List<ClassifiedPlayer> getBlackList(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getBlackList();
    }

    public static void setWhiteList(EntityPlayer playerIn, List<ClassifiedPlayer> whiteList) {
        MusicOptionsUtil.getImpl(playerIn).setWhiteList(whiteList);
        MusicOptionsUtil.sync(playerIn, 4);
    }

    public static List<ClassifiedPlayer> getWhiteList(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getWhiteList();
    }

    public static boolean isSoundRangeInfinityAllowed(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).isSoundRangeInfinityRangeAllowed();
    }

    public static void setSoundRangeInfinityAllowed(EntityPlayer playerIn, boolean isAllowed) {
        MusicOptionsUtil.getImpl(playerIn).setSoundRangeInfinityAllowed(isAllowed);
    }

    public static boolean isMxTuneServerUpdateAllowed(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).isMxTuneServerUpdateAllowed();
    }

    public static void setMxTuneServerUpdateAllowed(EntityPlayer playerIn, boolean isAllowed) {
        MusicOptionsUtil.getImpl(playerIn).setMxTuneServerUpdateAllowed(isAllowed);
        MusicOptionsUtil.sync(playerIn, 6);
    }

    public static void setSelectedPlayListGuid(EntityPlayer playerIn, GUID guidPlayList) {
        MusicOptionsUtil.getImpl(playerIn).setSelectedPlayListGuid(guidPlayList);
        MusicOptionsUtil.sync(playerIn, 7);
    }

    public static GUID getSelectedPlayListGuid(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getSelectedPlayListGuid();
    }

    public static void setCtrlKey(EntityPlayer playerIn, boolean isDown) {
        MusicOptionsUtil.getImpl(playerIn).setCtrlKey(isDown);
        MusicOptionsUtil.sync(playerIn, 8);
    }

    public static boolean isCtrlKeyDown(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).isCtrlKeyDown();
    }

    @Nullable
    private static IPlayerMusicOptions getImpl(EntityPlayer player) {
        if (!player.hasCapability(Objects.requireNonNull(MUSIC_OPTIONS), null)) {
            throw new MXTuneRuntimeException("IBardAction capability is null");
        }
        IPlayerMusicOptions bardActionImpl = (IPlayerMusicOptions)player.getCapability(MUSIC_OPTIONS, null);
        return bardActionImpl;
    }

    public static void setChunkToolOperation(EntityPlayer playerIn, ChunkToolMessage.Operation operation) {
        MusicOptionsUtil.getImpl(playerIn).setChunkToolOperation(operation);
        MusicOptionsUtil.sync(playerIn, 9);
    }

    public static ChunkToolMessage.Operation getChunkToolOperation(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getChunkToolOperation();
    }

    public static void setChunkStart(EntityPlayer playerIn, @Nullable Chunk chunkStart) {
        MusicOptionsUtil.getImpl(playerIn).setChunkStart(chunkStart);
    }

    @Nullable
    public static Chunk getChunkStart(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getChunkStart();
    }

    public static void setChunkEnd(EntityPlayer playerIn, @Nullable Chunk chunkEnd) {
        MusicOptionsUtil.getImpl(playerIn).setChunkEnd(chunkEnd);
    }

    @Nullable
    public static Chunk getChunkEnd(EntityPlayer playerIn) {
        return MusicOptionsUtil.getImpl(playerIn).getChunkEnd();
    }

    public static int getAdjustPositionHud() {
        return adjustPositionHud;
    }

    public static void setAdjustPositionHud(int posHud) {
        adjustPositionHud = posHud;
    }

    public static void setAdjustSizeHud(float sizeHud) {
        adjustSizeHud = sizeHud;
    }

    public static float getAdjustSizeHud() {
        return adjustSizeHud;
    }

    public static boolean playerNotMuted(@Nullable EntityPlayer playerIn, @Nullable EntityPlayer otherPlayer) {
        boolean result = false;
        if (playerIn != null && otherPlayer != null) {
            switch (MusicOptionsUtil.getMuteOptionEnum(playerIn)) {
                case OFF: {
                    break;
                }
                case ALL: {
                    result = true;
                    break;
                }
                case OTHERS: {
                    result = !playerIn.equals((Object)otherPlayer);
                    break;
                }
                case WHITELIST: {
                    result = !MusicOptionsUtil.isPlayerInList(playerIn, otherPlayer, MusicOptionsUtil.getWhiteList(playerIn));
                    break;
                }
                case BLACKLIST: {
                    result = MusicOptionsUtil.isPlayerInList(playerIn, otherPlayer, MusicOptionsUtil.getBlackList(playerIn));
                    break;
                }
            }
        }
        return !result;
    }

    private static boolean isPlayerInList(EntityPlayer playerIn, EntityPlayer otherPlayer, List<ClassifiedPlayer> playerList) {
        boolean inList = false;
        if (!playerIn.equals((Object)otherPlayer)) {
            for (ClassifiedPlayer w : playerList) {
                if (!w.getUuid().equals(otherPlayer.func_110124_au())) continue;
                inList = true;
                break;
            }
        }
        return inList;
    }

    static void syncAll(EntityPlayer playerIn) {
        MusicOptionsUtil.sync(playerIn, 0);
    }

    public static void sync(EntityPlayer playerIn, int propertyID) {
        if (!playerIn.func_130014_f_().field_72995_K) {
            PacketDispatcher.sendTo(new SyncPlayerMusicOptionsMessage((IPlayerMusicOptions)playerIn.getCapability(Objects.requireNonNull(MUSIC_OPTIONS), null), propertyID), (EntityPlayerMP)playerIn);
        }
    }

    public static enum EnumMuteOptions implements IStringSerializable
    {
        OFF(0, "mxtune.gui.musicOptions.muteOption.off"),
        OTHERS(1, "mxtune.gui.musicOptions.muteOption.others"),
        BLACKLIST(2, "mxtune.gui.musicOptions.muteOption.blacklist"),
        WHITELIST(3, "mxtune.gui.musicOptions.muteOption.whitelist"),
        ALL(4, "mxtune.gui.musicOptions.muteOption.all");

        private final int index;
        private final String translateKey;
        private static final EnumMuteOptions[] INDEX_LOOKUP;

        private EnumMuteOptions(int index, String translateKey) {
            this.index = index;
            this.translateKey = translateKey;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumMuteOptions byIndex(int indexIn) {
            int index = indexIn;
            if (index < 0 || index >= INDEX_LOOKUP.length) {
                index = 0;
            }
            return INDEX_LOOKUP[index];
        }

        public String toString() {
            return I18n.func_135052_a((String)this.translateKey, (Object[])new Object[0]);
        }

        public String func_176610_l() {
            return this.translateKey;
        }

        static {
            INDEX_LOOKUP = new EnumMuteOptions[EnumMuteOptions.values().length];
            EnumMuteOptions[] enumMuteOptionsArray = EnumMuteOptions.values();
            int n = enumMuteOptionsArray.length;
            for (int i = 0; i < n; ++i) {
                EnumMuteOptions value;
                EnumMuteOptions.INDEX_LOOKUP[value.getIndex()] = value = enumMuteOptionsArray[i];
            }
        }
    }
}

