/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.server;

import net.aeronica.mods.mxtune.blocks.TileBandAmp;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.sound.SoundRange;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.world.IModLockableContainer;
import net.aeronica.mods.mxtune.world.OwnerUUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.LockCode;
import net.minecraftforge.fml.relauncher.Side;

public class BandAmpMessage
extends AbstractMessage.AbstractServerMessage<BandAmpMessage> {
    private boolean lockContainer;
    private BlockPos pos;
    private boolean rearRedstoneInputEnabled;
    private boolean leftRedstoneOutputEnabled;
    private boolean rightRedstoneOutputEnabled;
    private SoundRange soundRange;

    public BandAmpMessage() {
    }

    public BandAmpMessage(BlockPos pos, boolean lockContainer, boolean rearRedstoneInputEnabled, boolean leftRedstoneOutputEnabled, boolean rightRedstoneOutputEnabled, SoundRange soundRange) {
        this.pos = pos;
        this.lockContainer = lockContainer;
        this.rearRedstoneInputEnabled = rearRedstoneInputEnabled;
        this.leftRedstoneOutputEnabled = leftRedstoneOutputEnabled;
        this.rightRedstoneOutputEnabled = rightRedstoneOutputEnabled;
        this.soundRange = soundRange;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.lockContainer = buffer.readBoolean();
        this.rearRedstoneInputEnabled = buffer.readBoolean();
        this.leftRedstoneOutputEnabled = buffer.readBoolean();
        this.rightRedstoneOutputEnabled = buffer.readBoolean();
        this.soundRange = (SoundRange)buffer.func_179257_a(SoundRange.class);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBoolean(this.lockContainer);
        buffer.writeBoolean(this.rearRedstoneInputEnabled);
        buffer.writeBoolean(this.leftRedstoneOutputEnabled);
        buffer.writeBoolean(this.rightRedstoneOutputEnabled);
        buffer.func_179249_a((Enum)this.soundRange);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (player.field_70170_p.func_175667_e(this.pos)) {
            TileEntity tileEntity = player.field_70170_p.func_175625_s(this.pos);
            this.processLockButton(player, tileEntity);
            this.processButtons(player, tileEntity);
        }
    }

    private void processLockButton(EntityPlayer player, TileEntity tileEntity) {
        OwnerUUID ownerUUID;
        IModLockableContainer lockableContainer;
        if (tileEntity instanceof IModLockableContainer && (lockableContainer = (IModLockableContainer)tileEntity).isOwner(ownerUUID = new OwnerUUID(player.getPersistentID()))) {
            if (this.lockContainer) {
                LockCode lockCode = new LockCode("Locked by Owner");
                lockableContainer.setLockCode(lockCode);
            } else {
                lockableContainer.setLockCode(LockCode.field_180162_a);
            }
        }
    }

    private void processButtons(EntityPlayer entityPlayer, TileEntity tileEntity) {
        if (tileEntity instanceof TileBandAmp && ((TileBandAmp)tileEntity).getOwner().getUUID().equals(entityPlayer.getPersistentID())) {
            TileBandAmp tileBandAmp = (TileBandAmp)tileEntity;
            tileBandAmp.setRearRedstoneInputEnabled(this.rearRedstoneInputEnabled);
            tileBandAmp.setLeftRedstoneOutputEnabled(this.leftRedstoneOutputEnabled);
            tileBandAmp.setRightRedstoneOutputEnabled(this.rightRedstoneOutputEnabled);
            if (this.soundRange == SoundRange.INFINITY && !MusicOptionsUtil.isSoundRangeInfinityAllowed(entityPlayer)) {
                tileBandAmp.setSoundRange(SoundRange.NORMAL);
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.gui.bandAmp.soundRangeInfinityNotAllowed", new Object[0]));
                Miscellus.audiblePingPlayer(entityPlayer, SoundEvents.field_189107_dL);
            } else {
                tileBandAmp.setSoundRange(this.soundRange);
            }
        }
    }
}

