/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;

public class UpdateChunkMusicData
extends AbstractMessage.AbstractClientMessage<UpdateChunkMusicData> {
    private int chunkX;
    private int chunkZ;
    private GUID guid;
    private long ddddSigBits;
    private long ccccSigBits;
    private long bbbbSigBits;
    private long aaaaSigBits;

    public UpdateChunkMusicData() {
    }

    public UpdateChunkMusicData(int chunkX, int chunkZ, GUID guid) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.guid = guid;
        this.ddddSigBits = guid.getDdddSignificantBits();
        this.ccccSigBits = guid.getCcccSignificantBits();
        this.bbbbSigBits = guid.getBbbbSignificantBits();
        this.aaaaSigBits = guid.getAaaaSignificantBits();
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.chunkX = buffer.readInt();
        this.chunkZ = buffer.readInt();
        this.ddddSigBits = buffer.readLong();
        this.ccccSigBits = buffer.readLong();
        this.bbbbSigBits = buffer.readLong();
        this.aaaaSigBits = buffer.readLong();
        this.guid = new GUID(this.ddddSigBits, this.ccccSigBits, this.bbbbSigBits, this.aaaaSigBits);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeInt(this.chunkX);
        buffer.writeInt(this.chunkZ);
        buffer.writeLong(this.ddddSigBits);
        buffer.writeLong(this.ccccSigBits);
        buffer.writeLong(this.bbbbSigBits);
        buffer.writeLong(this.aaaaSigBits);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        Chunk chunk;
        World world = MXTune.proxy.getClientWorld();
        if (world != null && world.func_190526_b(this.chunkX, this.chunkZ) && (chunk = world.func_72964_e(this.chunkX, this.chunkZ)).hasCapability(ModChunkPlaylistHelper.MOD_CHUNK_DATA, null)) {
            ModChunkPlaylistHelper.setPlaylistGuid(chunk, this.guid);
        }
    }
}

