/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.NetworkStringHelper;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PlayJamMessage
extends AbstractMessage.AbstractClientMessage<PlayJamMessage> {
    private Integer leaderID;
    private Integer playID;
    private String jamMML;
    private NetworkStringHelper stringHelper = new NetworkStringHelper();

    public PlayJamMessage() {
    }

    public PlayJamMessage(Integer leaderID, Integer playID, String jamMML) {
        this.leaderID = leaderID;
        this.playID = playID;
        this.jamMML = jamMML;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.leaderID = buffer.readInt();
        this.playID = buffer.readInt();
        this.jamMML = this.stringHelper.readLongString(buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeInt(this.leaderID.intValue());
        buffer.writeInt(this.playID.intValue());
        this.stringHelper.writeLongString(buffer, this.jamMML);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        EntityPlayer otherPlayer;
        if (!MIDISystemUtil.midiUnavailableWarn(player) && MusicOptionsUtil.playerNotMuted(player, otherPlayer = (EntityPlayer)player.func_130014_f_().func_73045_a(GroupHelper.getMembersGroupLeader(this.leaderID)))) {
            ModLogger.debug("musicText:  " + this.jamMML.substring(0, Math.min(25, this.jamMML.length())), new Object[0]);
            ModLogger.debug("playID:     " + this.playID, new Object[0]);
            GroupHelper.addServerManagedActivePlayID(this.playID);
            ClientAudio.play(this.playID, this.jamMML);
        }
    }
}

