/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.bidirectional;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.ClientPlayManager;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTuneFileHelper;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.MXTuneException;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

public class GetServerDataMessage
extends AbstractMessage<GetServerDataMessage> {
    private boolean errorResult = false;
    private boolean fileError = false;
    private RecordType recordType = RecordType.PLAY_LIST;
    private NBTTagCompound dataCompound = new NBTTagCompound();
    private long ddddSigBits;
    private long ccccSigBits;
    private long bbbbSigBits;
    private long aaaaSigBits;
    private GUID dataTypeUuid;
    private int playId = -1;

    public GetServerDataMessage() {
    }

    public GetServerDataMessage(GUID guidType, RecordType recordType) {
        this.recordType = recordType;
        this.ddddSigBits = guidType.getDdddSignificantBits();
        this.ccccSigBits = guidType.getCcccSignificantBits();
        this.bbbbSigBits = guidType.getBbbbSignificantBits();
        this.aaaaSigBits = guidType.getAaaaSignificantBits();
    }

    public GetServerDataMessage(GUID guidType, RecordType recordType, int playId) {
        this.recordType = recordType;
        this.ddddSigBits = guidType.getDdddSignificantBits();
        this.ccccSigBits = guidType.getCcccSignificantBits();
        this.bbbbSigBits = guidType.getBbbbSignificantBits();
        this.aaaaSigBits = guidType.getAaaaSignificantBits();
        this.playId = playId;
    }

    private GetServerDataMessage(GUID guidType, RecordType recordType, int playId, NBTTagCompound dataCompound, boolean errorResult) {
        this.recordType = recordType;
        this.ddddSigBits = guidType.getDdddSignificantBits();
        this.ccccSigBits = guidType.getCcccSignificantBits();
        this.bbbbSigBits = guidType.getBbbbSignificantBits();
        this.aaaaSigBits = guidType.getAaaaSignificantBits();
        this.playId = playId;
        this.dataCompound = dataCompound;
        this.errorResult = errorResult;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.recordType = (RecordType)buffer.func_179257_a(RecordType.class);
        this.dataCompound = buffer.func_150793_b();
        this.ddddSigBits = buffer.readLong();
        this.ccccSigBits = buffer.readLong();
        this.bbbbSigBits = buffer.readLong();
        this.aaaaSigBits = buffer.readLong();
        this.errorResult = buffer.readBoolean();
        this.playId = buffer.readInt();
        this.dataTypeUuid = new GUID(this.ddddSigBits, this.ccccSigBits, this.bbbbSigBits, this.aaaaSigBits);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.recordType);
        buffer.func_150786_a(this.dataCompound);
        buffer.writeLong(this.ddddSigBits);
        buffer.writeLong(this.ccccSigBits);
        buffer.writeLong(this.bbbbSigBits);
        buffer.writeLong(this.aaaaSigBits);
        buffer.writeBoolean(this.errorResult);
        buffer.writeInt(this.playId);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            this.handleClientSide();
        } else {
            this.handleServerSide(player);
        }
    }

    private void handleClientSide() {
        if (this.errorResult) {
            ModLogger.warn((Object)((Object)this.recordType) + " file: " + this.dataTypeUuid.toString() + ".dat" + " does not exist on the server", new Object[0]);
        }
        switch (this.recordType) {
            case PLAY_LIST: {
                ClientFileManager.addPlayList(this.dataTypeUuid, this.dataCompound, this.errorResult);
                break;
            }
            case SONG: {
                ClientFileManager.addSong(this.dataTypeUuid, this.dataCompound, this.errorResult);
                ClientPlayManager.playMusic(this.dataTypeUuid, this.playId);
                break;
            }
        }
    }

    private void handleServerSide(EntityPlayer playerIn) {
        switch (this.recordType) {
            case PLAY_LIST: {
                this.dataCompound = this.getDataCompoundFromFile("mxtune/playlists", this.dataTypeUuid);
                break;
            }
            case SONG: {
                this.dataCompound = this.getDataCompoundFromMXTuneFile("mxtune/music", this.dataTypeUuid);
                break;
            }
        }
        PacketDispatcher.sendTo(new GetServerDataMessage(this.dataTypeUuid, this.recordType, this.playId, this.dataCompound, this.fileError), (EntityPlayerMP)playerIn);
    }

    private NBTTagCompound getDataCompoundFromFile(String folder, GUID dataTypeGuid) {
        Path path;
        NBTTagCompound emptyData = new NBTTagCompound();
        Boolean fileExists = FileHelper.fileExists(folder, dataTypeGuid.toString() + ".dat", Side.SERVER);
        if (!fileExists.booleanValue()) {
            Path path2 = Paths.get(folder, dataTypeGuid.toString() + ".dat");
            ModLogger.warn(path2.toString() + " not found!", new Object[0]);
            this.fileError = true;
            return emptyData;
        }
        try {
            path = FileHelper.getCacheFile(folder, dataTypeGuid.toString() + ".dat", Side.SERVER);
        }
        catch (IOException e) {
            ModLogger.error(e);
            this.fileError = true;
            return emptyData;
        }
        this.fileError = false;
        return FileHelper.getCompoundFromFile(path);
    }

    private NBTTagCompound getDataCompoundFromMXTuneFile(String folder, GUID dataTypeGuid) {
        MXTuneFile mxTuneFile;
        NBTTagCompound emptyData = new NBTTagCompound();
        Boolean fileExists = FileHelper.fileExists(folder, dataTypeGuid.toString() + ".mxt", Side.SERVER);
        if (!fileExists.booleanValue()) {
            Path path = Paths.get(folder, dataTypeGuid.toString() + ".mxt");
            ModLogger.warn(path.toString() + " not found!", new Object[0]);
            this.fileError = true;
            return emptyData;
        }
        try {
            Path path = FileHelper.getCacheFile(folder, dataTypeGuid.toString() + ".mxt", Side.SERVER);
            mxTuneFile = MXTuneFileHelper.getMXTuneFile(path);
            if (mxTuneFile == null) {
                throw new MXTuneException(new TextComponentTranslation("mxtune.error.unexpected_data_error", new Object[]{path.toString()}).func_150261_e());
            }
        }
        catch (IOException | MXTuneException e) {
            ModLogger.error(e);
            this.fileError = true;
            return emptyData;
        }
        this.fileError = false;
        Song song = MXTuneFileHelper.getSong(mxTuneFile);
        NBTTagCompound songData = new NBTTagCompound();
        song.writeToNBT(songData);
        return songData;
    }
}

