/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.mxt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.aeronica.mods.mxtune.mxt.MXTuneStaff;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MXTunePart
implements Serializable {
    private static final long serialVersionUID = -76034260522031311L;
    private static final String TAG_INSTRUMENT = "instrument";
    private static final String TAG_PACKED_PATCH = "packedPatch";
    private static final String TAG_META = "meta";
    private static final String TAG_STAFF_PREFIX = "staff";
    private static final String TAG_STAFF_COUNT = "staffCount";
    private static final String TAG_TRANSPOSE = "transpose";
    private String instrumentName;
    private int packedPatch;
    private String meta;
    private int transpose;
    private List<MXTuneStaff> staves;

    public MXTunePart() {
        this.meta = "";
        this.instrumentName = "";
        this.staves = new ArrayList<MXTuneStaff>();
        this.transpose = 0;
    }

    public MXTunePart(String instrumentName, String meta, int packedPatch, List<MXTuneStaff> staves) {
        this.meta = meta != null ? meta : "";
        this.instrumentName = instrumentName != null ? instrumentName : "";
        this.packedPatch = packedPatch;
        this.staves = staves != null ? staves : new ArrayList();
        this.transpose = 0;
    }

    public MXTunePart(NBTTagCompound compound) {
        this.instrumentName = compound.func_74779_i(TAG_INSTRUMENT);
        this.meta = compound.func_74779_i(TAG_META);
        this.packedPatch = compound.func_74762_e(TAG_PACKED_PATCH);
        this.transpose = compound.func_74762_e(TAG_TRANSPOSE);
        int staffCount = compound.func_74762_e(TAG_STAFF_COUNT);
        this.staves = new ArrayList<MXTuneStaff>();
        for (int i = 0; i < staffCount; ++i) {
            NBTTagCompound compoundStaff = compound.func_74775_l(TAG_STAFF_PREFIX + i);
            this.staves.add(new MXTuneStaff(i, compoundStaff));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a(TAG_INSTRUMENT, this.instrumentName);
        compound.func_74778_a(TAG_META, this.meta);
        compound.func_74768_a(TAG_PACKED_PATCH, this.packedPatch);
        compound.func_74768_a(TAG_TRANSPOSE, this.transpose);
        compound.func_74768_a(TAG_STAFF_COUNT, this.staves.size());
        int i = 0;
        for (MXTuneStaff staff : this.staves) {
            NBTTagCompound compoundStaff = new NBTTagCompound();
            staff.writeToNBT(compoundStaff);
            compound.func_74782_a(TAG_STAFF_PREFIX + i, (NBTBase)compoundStaff);
            ++i;
        }
    }

    public List<MXTuneStaff> getStaves() {
        return this.staves != null ? this.staves : Collections.emptyList();
    }

    public void setStaves(List<MXTuneStaff> staves) {
        this.staves = staves;
    }

    public String getInstrumentName() {
        return this.instrumentName != null ? this.instrumentName : "";
    }

    public void setInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
    }

    public String getMeta() {
        return this.meta != null ? this.meta : "";
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public int getPackedPatch() {
        return this.packedPatch;
    }

    public void setPackedPatch(int packedPatch) {
        this.packedPatch = packedPatch;
    }

    public int getTranspose() {
        return this.transpose;
    }

    public void setTranspose(int transpose) {
        this.transpose = transpose;
    }
}

