/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import net.aeronica.mods.mxtune.model.ItemCameraTransformsDeserializer;
import net.aeronica.mods.mxtune.model.ItemTransformVec3fDeserializer;
import net.aeronica.mods.mxtune.model.ModelMultiTex;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;

public class ModelLoader
implements ICustomModelLoader,
JsonDeserializationContext {
    public static final ModelLoader INSTANCE = new ModelLoader();
    public static String EXTENSION = ".mtex";
    private final Gson gson = new GsonBuilder().registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3fDeserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransformsDeserializer()).create();
    private final JsonParser parser = new JsonParser();
    private final ModelBlock.Deserializer modelBlockDeserializer = new ModelBlock.Deserializer();
    private IResourceManager manager;

    private ModelLoader() {
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        String modelPath = modelLocation.func_110623_a();
        modelPath = modelPath.substring(0, modelPath.lastIndexOf(46)) + ".mtex.json";
        IResource resource = this.manager.func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), modelPath));
        InputStreamReader jsonStream = new InputStreamReader(resource.func_110527_b());
        JsonElement json = this.parser.parse((Reader)jsonStream);
        jsonStream.close();
        ModelBlock modelBlock = this.modelBlockDeserializer.deserialize(json, ModelBlock.class, (JsonDeserializationContext)this);
        return new ModelMultiTex(modelBlock);
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (modelLocation.func_110624_b().contains("mxtune")) {
            ModLogger.debug("ModelLoader#accepts %s. accept=%s", modelLocation.toString(), modelLocation.func_110623_a().endsWith(EXTENSION));
        }
        return modelLocation.func_110624_b().contains("mxtune") && modelLocation.func_110623_a().endsWith(EXTENSION);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
    }

    public <T> T deserialize(JsonElement json, Type type) throws JsonParseException {
        return (T)this.gson.fromJson(json, type);
    }
}

