/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers.records;

import net.aeronica.mods.mxtune.managers.records.BaseData;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.aeronica.mods.mxtune.util.ValidDuration;
import net.minecraft.nbt.NBTTagCompound;

public class Song
extends BaseData {
    private static final String TAG_TITLE = "title";
    private static final String TAG_MML = "mml";
    private static final String TAG_DURATION = "duration";
    private static final String NULL_MML = "@MML;";
    private String title;
    private String mml;
    private int duration;

    public Song() {
        this.title = "";
        this.mml = NULL_MML;
        this.duration = 0;
    }

    public Song(String title, String mml) {
        this.title = title.trim();
        this.mml = mml != null ? mml.trim() : NULL_MML;
        ValidDuration validDuration = SheetMusicUtil.validateMML(this.mml);
        this.duration = validDuration.getDuration();
        this.guid = GUID.stringToSHA2Hash(this.title);
    }

    public Song(NBTTagCompound compound) {
        this.readFromNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.title = compound.func_74779_i(TAG_TITLE);
        this.mml = compound.func_74779_i(TAG_MML);
        this.duration = compound.func_74762_e(TAG_DURATION);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a(TAG_TITLE, this.title);
        compound.func_74778_a(TAG_MML, this.mml);
        compound.func_74768_a(TAG_DURATION, this.duration);
    }

    public String getTitle() {
        return this.title;
    }

    public String getMml() {
        return this.mml;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public <T extends BaseData> T factory() {
        return (T)new Song();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

