/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.aeronica.libs.mml.util.TestData;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTuneFileHelper;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.MXTuneRuntimeException;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.NBTHelper;
import net.aeronica.mods.mxtune.util.ResultMessage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

public class ServerFileManager {
    private static final String FORMAT_UNABLE_TO_CREATE = "Unable to create folder: %s and/or file: %s";
    private static final String SERVER_ID_FILE = "server_id.dat";
    private static final String SERVER_ID_FILE_ERROR = "Delete the <world save>/mxtune/server_id.dat file, then try loading the world again.";
    private static UUID serverID;
    private static final Map<GUID, SongProxy> songProxyMap;
    private static final Map<GUID, PlayList> playLists;

    private ServerFileManager() {
    }

    public static void start() {
        ServerFileManager.getOrGenerateServerID();
        new Thread(() -> {
            ServerFileManager.initPlayLists();
            ServerFileManager.initSongs();
            ServerFileManager.dumpAll();
        }).start();
    }

    public static void shutdown() {
        songProxyMap.clear();
        playLists.clear();
    }

    private static void getOrGenerateServerID() {
        boolean fileExists = FileHelper.fileExists("mxtune", SERVER_ID_FILE, Side.SERVER);
        if (fileExists) {
            try {
                Path serverDatFile = FileHelper.getCacheFile("mxtune", SERVER_ID_FILE, Side.SERVER);
                NBTTagCompound compound = FileHelper.getCompoundFromFile(serverDatFile);
                if (compound == null) {
                    throw new NullPointerException("NBTTagCompound compound is null!");
                }
                serverID = NBTHelper.getUuidFromCompound(compound);
            }
            catch (IOException | NullPointerException e) {
                ModLogger.error("The %s/%s file could not be read.", "mxtune", SERVER_ID_FILE);
                throw new MXTuneRuntimeException(SERVER_ID_FILE_ERROR, e);
            }
        }
        try {
            Path serverDatFile = FileHelper.getCacheFile("mxtune", SERVER_ID_FILE, Side.SERVER);
            serverID = UUID.randomUUID();
            NBTTagCompound compound = new NBTTagCompound();
            NBTHelper.setUuidToCompound(compound, serverID);
            FileHelper.sendCompoundToFile(serverDatFile, compound);
        }
        catch (IOException e) {
            ModLogger.error("The %s/%s file could not be written.", "mxtune", SERVER_ID_FILE);
            throw new MXTuneRuntimeException(SERVER_ID_FILE_ERROR, e);
        }
    }

    public static UUID getServerID() {
        return serverID;
    }

    private static void initSongs() {
        List<Object> songFiles = new ArrayList();
        Path path = FileHelper.getDirectory("mxtune/music", Side.SERVER);
        PathMatcher filter = FileHelper.getMxtMatcher(path);
        try (Stream<Path> paths = Files.list(path);){
            songFiles = paths.filter(filter::matches).collect(Collectors.toList());
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
        }
        for (Path songFile : songFiles) {
            MXTuneFile mxTuneFile = MXTuneFileHelper.getMXTuneFile(songFile);
            if (mxTuneFile != null) {
                SongProxy songProxy = MXTuneFileHelper.getSongProxy(mxTuneFile);
                songProxyMap.put(songProxy.getGUID(), songProxy);
                continue;
            }
            ModLogger.warn("NULL mxTuneFile for song file: %s", songFile.toString());
        }
    }

    public static synchronized List<SongProxy> getSongProxies() {
        ArrayList<SongProxy> songProxies = new ArrayList<SongProxy>();
        songProxyMap.forEach((key, value) -> songProxies.add((SongProxy)value));
        return songProxies;
    }

    private static void initPlayLists() {
        PlayList nullPlaylist = PlayList.undefinedPlaylist();
        playLists.put(nullPlaylist.getGUID(), nullPlaylist);
        PlayList noPlaylists = PlayList.emptyPlaylist();
        playLists.put(noPlaylists.getGUID(), noPlaylists);
        List<Object> playListFiles = new ArrayList();
        Path path = FileHelper.getDirectory("mxtune/playlists", Side.SERVER);
        PathMatcher filter = FileHelper.getDatMatcher(path);
        try (Stream<Path> paths = Files.list(path);){
            playListFiles = paths.filter(filter::matches).collect(Collectors.toList());
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
        }
        for (Path pathPlayList : playListFiles) {
            NBTTagCompound compound = FileHelper.getCompoundFromFile(pathPlayList);
            if (compound == null) continue;
            PlayList playList = PlayList.build(compound);
            GUID playListGUID = playList.getGUID();
            playLists.put(playListGUID, playList);
        }
    }

    public static synchronized List<PlayList> getPlayLists() {
        ArrayList<PlayList> playListList = new ArrayList<PlayList>();
        playLists.forEach((key, value) -> playListList.add((PlayList)value));
        return playListList;
    }

    public static synchronized PlayList getPlayList(GUID guidPlayList) {
        return playLists.containsKey(guidPlayList) ? playLists.get(guidPlayList) : PlayList.undefinedPlaylist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultMessage setPlayList(GUID dataTypeUuid, PlayList playList) {
        ResultMessage errorResult = ResultMessage.NO_ERROR;
        if (playList == null) throw new MXTuneRuntimeException("dataCompound is null in ServerFileManager.setPlayList");
        GUID playListGUID = playList.getGUID();
        if (!dataTypeUuid.equals(playListGUID)) throw new MXTuneRuntimeException("GUID Mismatch in transport: Corrupted PlayList data");
        String playListFileName = playList.getFileName();
        try {
            NBTTagCompound compound = new NBTTagCompound();
            playList.writeToNBT(compound);
            Path path = FileHelper.getCacheFile("mxtune/playlists", playListFileName, Side.SERVER);
            FileHelper.sendCompoundToFile(path, compound);
        }
        catch (IOException e) {
            ModLogger.error(e);
            ModLogger.warn(FORMAT_UNABLE_TO_CREATE, "mxtune/playlists", playListFileName);
            errorResult = new ResultMessage(true, (ITextComponent)new TextComponentTranslation("mxtune.error.unable_to_create_file_folder", new Object[]{"mxtune/playlists", playListFileName}));
        }
        if (errorResult.hasError().booleanValue()) return errorResult;
        Map<GUID, PlayList> map = playLists;
        synchronized (map) {
            playLists.put(playListGUID, playList);
            return errorResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultMessage setMXTFile(GUID dataTypeUuid, MXTuneFile mxTuneFile) {
        ResultMessage errorResult = ResultMessage.NO_ERROR;
        if (mxTuneFile == null) throw new MXTuneRuntimeException("dataCompound is null in ServerFileManager.setSong");
        SongProxy songProxy = MXTuneFileHelper.getSongProxy(mxTuneFile);
        GUID songGUID = mxTuneFile.getGUID();
        if (!dataTypeUuid.equals(songGUID)) throw new MXTuneRuntimeException("GUID Mismatch in transport: Corrupted Song data");
        String songFileName = mxTuneFile.getFileName();
        try {
            NBTTagCompound dataCompound = new NBTTagCompound();
            mxTuneFile.writeToNBT(dataCompound);
            Path path = FileHelper.getCacheFile("mxtune/music", songFileName, Side.SERVER);
            FileHelper.sendCompoundToFile(path, dataCompound);
        }
        catch (IOException e) {
            ModLogger.warn(e);
            ModLogger.warn(FORMAT_UNABLE_TO_CREATE, "mxtune/music", songFileName);
            errorResult = new ResultMessage(true, (ITextComponent)new TextComponentTranslation("mxtune.error.unable_to_create_file_folder", new Object[]{"mxtune/music", songFileName}));
        }
        if (errorResult.hasError().booleanValue()) return errorResult;
        Map<GUID, SongProxy> map = songProxyMap;
        synchronized (map) {
            songProxyMap.put(songGUID, songProxy);
            return errorResult;
        }
    }

    private static void stuffServer() {
        ArrayList<SongProxy> songProxies = new ArrayList<SongProxy>();
        for (TestData testData : TestData.values()) {
            Song song = new Song(testData.getTitle(), testData.getMML());
            NBTTagCompound songCompound = new NBTTagCompound();
            SongProxy songProxy = new SongProxy(songCompound);
            songProxies.add(songProxy);
            song.writeToNBT(songCompound);
            try {
                Path path = FileHelper.getCacheFile("mxtune/music", song.getFileName(), Side.SERVER);
                FileHelper.sendCompoundToFile(path, songCompound);
            }
            catch (IOException e) {
                ModLogger.warn(e);
                ModLogger.warn(FORMAT_UNABLE_TO_CREATE, "mxtune/music", song.getFileName());
            }
        }
        String playListName = "Test PlayList";
        String playListFileName = "";
        try {
            NBTTagCompound compound = new NBTTagCompound();
            PlayList playList = new PlayList(playListName, songProxies, songProxies);
            playListFileName = playList.getFileName();
            Path path = FileHelper.getCacheFile("mxtune/playlists", playListFileName, Side.SERVER);
            playList.writeToNBT(compound);
            FileHelper.sendCompoundToFile(path, compound);
        }
        catch (IOException e) {
            ModLogger.warn(e);
            ModLogger.warn(FORMAT_UNABLE_TO_CREATE, "mxtune/playlists", playListFileName);
        }
    }

    private static void dumpAll() {
        ModLogger.debug("ServerFileManager: Play Lists", new Object[0]);
        playLists.forEach((key, value) -> ModLogger.debug("PlayList guid:  %s, Name:  %s", key.toString(), value.getName()));
        ModLogger.debug("ServerFileManager: Music", new Object[0]);
        songProxyMap.forEach((key, value) -> ModLogger.debug("Song guid:      %s, title: %s", key.toString(), value.getTitle()));
    }

    static {
        songProxyMap = new HashMap<GUID, SongProxy>();
        playLists = new HashMap<GUID, PlayList>();
    }
}

